/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.decision;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approval.ApprovalChangeListenerService;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecisionParameters;
import com.atlassian.servicedesk.internal.api.decision.InternalApproverDecisionService;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionManager;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionParametersImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalPermissionChecker;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Either;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalApproverDecisionServiceImpl
implements InternalApproverDecisionService {
    private Logger logger = LoggerFactory.getLogger(InternalApproverDecisionServiceImpl.class);
    private final ApproverDecisionManager approverDecisionManager;
    private final ApprovalChangeListenerService approvalChangeListenerService;
    private final ApprovalPermissionChecker approvalPermissionChecker;
    private final ApprovalError approvalError;

    @Autowired
    public InternalApproverDecisionServiceImpl(ApproverDecisionManager approverDecisionManager, ApprovalChangeListenerService approvalChangeListenerService, ApprovalPermissionChecker approvalPermissionChecker, ApprovalError approvalError) {
        this.approverDecisionManager = approverDecisionManager;
        this.approvalChangeListenerService = approvalChangeListenerService;
        this.approvalPermissionChecker = approvalPermissionChecker;
        this.approvalError = approvalError;
    }

    public ApproverDecisionParameters.Builder newDecisionBuilder() {
        return new ApproverDecisionParametersImpl.BuilderImpl();
    }

    public Either<AnError, ApproverDecision> createApproverDecision(ApplicationUser user, ApproverDecisionParameters decisionParams) {
        ApproverDecisionParametersImpl inputImpl = (ApproverDecisionParametersImpl)decisionParams;
        Approval approval = inputImpl.getApproval();
        Either<AnError, ApplicationUser> checkPermissionEith = this.approvalPermissionChecker.canApprove(user, approval);
        if (checkPermissionEith.isLeft()) {
            return Either.left((Object)checkPermissionEith.left().get());
        }
        Either<AnError, ApproverDecisionParameters> validatedResult = this.validateDecisionParams(decisionParams);
        if (validatedResult.isLeft()) {
            return Either.left((Object)validatedResult.left().get());
        }
        Either<AnError, ApproverDecision> result = this.approverDecisionManager.createApproverDecision(decisionParams);
        if (result.isLeft()) {
            return Either.left((Object)result.left().get());
        }
        this.approvalChangeListenerService.updateApprovalDecisionStateAndReindexApproval(user, approval);
        return result;
    }

    public boolean hasApproverMadeDecision(Approval approval, ApplicationUser user) {
        return this.approverDecisionManager.hasApproverMadeDecision(approval, user);
    }

    public Collection<ApproverDecision> getApproversDecisions(Approval approval) {
        return this.approverDecisionManager.getApproversDecisions(approval);
    }

    private Either<AnError, ApproverDecisionParameters> validateDecisionParams(@Nonnull ApproverDecisionParameters decisionParams) {
        Assertions.notNull((String)"DecisionParams is required", (Object)decisionParams);
        ApproverDecisionParametersImpl approverDecisionParams = (ApproverDecisionParametersImpl)decisionParams;
        ApplicationUser approver = approverDecisionParams.getApprover();
        Approval approval = approverDecisionParams.getApproval();
        if (approval.getDecision().isDefined()) {
            return Either.left((Object)this.approvalError.APPROVAL_DECISION_WAS_SET());
        }
        if (this.approverDecisionManager.hasApproverMadeDecision(approval, approver)) {
            return Either.left((Object)this.approvalError.APPROVER_HAS_MADE_DECISION());
        }
        return Either.right((Object)decisionParams);
    }
}

