/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.decision;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecisionParameters;

public class ApproverDecisionParametersImpl
implements ApproverDecisionParameters {
    private final Approval approval;
    private final ApprovalDecisionType decision;
    private final ApplicationUser approver;

    private ApproverDecisionParametersImpl(ApprovalDecisionType decision, Approval approval, ApplicationUser approver) {
        this.decision = decision;
        this.approval = approval;
        this.approver = approver;
    }

    public ApprovalDecisionType getDecision() {
        return this.decision;
    }

    public ApplicationUser getApprover() {
        return this.approver;
    }

    public Approval getApproval() {
        return this.approval;
    }

    public static BuilderImpl builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl
    implements ApproverDecisionParameters.Builder {
        private Approval approval;
        private ApprovalDecisionType decision;
        private ApplicationUser approver;

        public ApproverDecisionParameters.Builder approval(Approval approval) {
            this.approval = approval;
            return this;
        }

        public BuilderImpl approvalDecision(ApprovalDecisionType decision) {
            this.decision = decision;
            return this;
        }

        public ApproverDecisionParameters.Builder approver(ApplicationUser approver) {
            this.approver = approver;
            return this;
        }

        public ApproverDecisionParameters build() {
            return new ApproverDecisionParametersImpl(this.decision, this.approval, this.approver);
        }
    }
}

