/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.decision;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecision;
import com.atlassian.servicedesk.internal.api.decision.ApproverDecisionParameters;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApproverDecisionDao;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionManager;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionParametersImpl;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproverDecisionManagerImpl
implements ApproverDecisionManager {
    private final DatabaseAccessor databaseAccessor;
    private final ApproverDecisionDao approverDecisionDao;
    private final UserManager userManager;

    @Autowired
    public ApproverDecisionManagerImpl(DatabaseAccessor databaseAccessor, ApproverDecisionDao approverDecisionDao, UserManager userManager) {
        this.databaseAccessor = databaseAccessor;
        this.approverDecisionDao = approverDecisionDao;
        this.userManager = userManager;
    }

    @Override
    public Either<AnError, ApproverDecision> createApproverDecision(ApproverDecisionParameters decisionParameters) {
        return (Either)this.databaseAccessor.runInTransaction(databaseConnection -> {
            ApproverDecisionParametersImpl params = (ApproverDecisionParametersImpl)decisionParameters;
            return Either.right((Object)this.approverDecisionDao.create(params, (DatabaseConnection)databaseConnection));
        });
    }

    @Override
    public Set<String> getApprovedUserKeys(Approval approval) {
        return (Set)this.databaseAccessor.runInTransaction(databaseConnection -> this.approverDecisionDao.getApprovedUserKeys(approval, (DatabaseConnection)databaseConnection));
    }

    @Override
    public Set<String> getDeclinedUserKeys(Approval approval) {
        return (Set)this.databaseAccessor.runInTransaction(databaseConnection -> this.approverDecisionDao.getDeclinedUserKeys(approval, (DatabaseConnection)databaseConnection));
    }

    @Override
    public boolean hasApproverMadeDecision(Approval approval, ApplicationUser approver) {
        return (Boolean)this.databaseAccessor.run(databaseConnection -> this.approverDecisionDao.hasApproverMadeDecision(approval, approver, (DatabaseConnection)databaseConnection));
    }

    @Override
    public Collection<ApproverDecision> getApproversDecisions(Approval approval) {
        return (Collection)this.databaseAccessor.run(databaseConnection -> this.approverDecisionDao.getApproverDecisions(approval, (DatabaseConnection)databaseConnection));
    }

    @Override
    public boolean hasUserMadeAnyDecisionOnIssue(ApplicationUser user, Issue issue) {
        long numbOfDecision = (Long)this.databaseAccessor.run(databaseConnection -> this.approverDecisionDao.getUserDecisionCountForIssue(user, issue, (DatabaseConnection)databaseConnection));
        return numbOfDecision > 0L;
    }

    @Override
    public Set<ApplicationUser> getApproversWhoMadeDecision(Issue issue) {
        Set approverKeys = (Set)this.databaseAccessor.run(databaseConnection -> this.approverDecisionDao.getUserKeyofApproversWhoMadeDecision(issue, (DatabaseConnection)databaseConnection));
        return approverKeys.stream().map(userKey -> this.userManager.getUserByKey(userKey)).filter(user -> user != null).collect(Collectors.toSet());
    }
}

