/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.dao;

import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationDataInput;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationType;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationData;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApproverDao;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.schema.querydsl.mapping.Tables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ApproverDaoImpl
implements ApproverDao {
    @Override
    public void create(Approval approval, Collection<ApproverConfigurationDataInput> dataInputs, DatabaseConnection databaseConnection) {
        try {
            SQLInsertClause insertClause = databaseConnection.insert((RelationalPath)Tables.APPROVER);
            dataInputs.forEach(input -> insertClause.set(Tables.APPROVER.APPROVAL_ID, (Object)approval.getId()).set((Path)Tables.APPROVER.TYPE, (Object)input.getApproverConfigurationType().value()).set((Path)Tables.APPROVER.VALUE, (Object)input.getValue()).addBatch());
            insertClause.execute();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Approvers", ex);
        }
    }

    @Override
    public Collection<ApproverConfigurationData> getApproverData(Approval approval, DatabaseConnection databaseConnection) {
        try {
            List tuples = ((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVER.all()).from((Expression)Tables.APPROVER)).where((Predicate)Tables.APPROVER.APPROVAL_ID.eq((Object)approval.getId()))).fetch();
            return this.fromTuple2Data(tuples);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get Approvers for approvalId=" + approval.getId(), ex);
        }
    }

    @Override
    public Collection<ApproverConfigurationData> getActiveApproverConfigurations(Issue issue, DatabaseConnection databaseConnection) {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVER.all()).from((Expression)Tables.APPROVER)).join((EntityPath)Tables.APPROVAL)).on((Predicate)Tables.APPROVER.APPROVAL_ID.eq(Tables.APPROVAL.ID))).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()).and((Predicate)Tables.APPROVAL.DECISION.isNull()).and((Predicate)Tables.APPROVER.TYPE.eq((Object)ApproverConfigurationType.CUSTOM_FIELD.value())));
            List tuples = query.fetch();
            return this.fromTuple2Data(tuples);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get Custom Field Approvers for issue=" + issue.getId(), ex);
        }
    }

    @Override
    public Collection<ApproverConfigurationData> getAllApproverConfigurations(Issue issue, DatabaseConnection databaseConnection) {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.APPROVER.all()).from((Expression)Tables.APPROVER)).join((EntityPath)Tables.APPROVAL)).on((Predicate)Tables.APPROVER.APPROVAL_ID.eq(Tables.APPROVAL.ID))).where((Predicate)Tables.APPROVAL.ISSUE_ID.eq((Object)issue.getId()));
            List tuples = query.fetch();
            return this.fromTuple2Data(tuples);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Failed to get Custom Field Approvers for issue=" + issue.getId(), ex);
        }
    }

    private Collection<ApproverConfigurationData> fromTuple2Data(List<Tuple> tuples) {
        return tuples.stream().map(tuple -> new ApproverConfigurationData((Integer)tuple.get(Tables.APPROVER.APPROVAL_ID), ApproverConfigurationType.forKey((String)((String)tuple.get((Expression)Tables.APPROVER.TYPE))), (String)tuple.get((Expression)Tables.APPROVER.VALUE))).collect(Collectors.toSet());
    }
}

