/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.contextprovider;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.servicedesk.internal.api.approver.InternalApproverService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FirstPendingApprovalContextProvider
implements ContextProvider {
    private final InternalApproverService approverService;
    private static final String APPROVAL_ID_KEY = "approvalId";

    @Autowired
    public FirstPendingApprovalContextProvider(InternalApproverService approverService) {
        this.approverService = approverService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Option<ApplicationUser> user = this.getUser(context);
        Option<Issue> issue = this.getIssue(context);
        if (!user.isDefined() || !issue.isDefined()) {
            return context;
        }
        Either approvalResult = this.approverService.getFirstPendingApprovalForUser((Issue)issue.get(), (ApplicationUser)user.get());
        if (approvalResult.isRight()) {
            Option approvalOption = (Option)approvalResult.right().get();
            approvalOption.map(approval -> context.put(APPROVAL_ID_KEY, approval.getId()));
        }
        return context;
    }

    private Option<ApplicationUser> getUser(Map<String, Object> context) {
        return Option.option((Object)((ApplicationUser)context.get("user")));
    }

    private Option<Issue> getIssue(Map<String, Object> context) {
        return Option.option((Object)((Issue)context.get("issue")));
    }
}

