/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.condition;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.servicedesk.internal.api.approver.InternalApproverService;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class HasPendingApprovalsCondition
implements Condition {
    private final InternalApproverService approverService;
    private static final String ISSUE_KEY = "issue";
    private static final String USER_KEY = "user";

    @Autowired
    public HasPendingApprovalsCondition(InternalApproverService approverService) {
        this.approverService = approverService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Option<ApplicationUser> user = this.getUser(context);
        Option<Issue> issue = this.getIssue(context);
        if (!user.isDefined() || !issue.isDefined()) {
            return false;
        }
        return (Boolean)this.approverService.hasPendingApproval((Issue)issue.get(), (ApplicationUser)user.get()).fold(error -> false, isPending -> isPending);
    }

    private Option<ApplicationUser> getUser(Map<String, Object> context) {
        return Option.option((Object)((ApplicationUser)context.get(USER_KEY)));
    }

    private Option<Issue> getIssue(Map<String, Object> context) {
        return Option.option((Object)((Issue)context.get(ISSUE_KEY)));
    }
}

