/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.condition;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.servicedesk.internal.api.approval.InternalApprovalService;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class HasAnyApprovalsCondition
implements Condition {
    public static final String ISSUE_KEY = "issue";
    public static final String USER_KEY = "user";
    private InternalApprovalService approvalService;

    @Autowired
    public HasAnyApprovalsCondition(InternalApprovalService approvalService) {
        this.approvalService = approvalService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.hasAnyApprovals(context);
    }

    private boolean hasAnyApprovals(Map<String, Object> context) {
        Option<ApplicationUser> user = this.getUser(context);
        Option<Issue> issue = this.getIssue(context);
        if (!user.isDefined() || !issue.isDefined()) {
            return false;
        }
        return (Boolean)this.approvalService.getApprovals((ApplicationUser)user.get(), (Issue)issue.get()).fold(error -> false, approvals -> !approvals.isEmpty());
    }

    private Option<ApplicationUser> getUser(Map<String, Object> context) {
        return Option.option((Object)((ApplicationUser)context.get(USER_KEY)));
    }

    private Option<Issue> getIssue(Map<String, Object> context) {
        return Option.option((Object)((Issue)context.get(ISSUE_KEY)));
    }
}

