/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.condition;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.servicedesk.internal.api.approver.InternalApproverService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ApprovalActionEnabledCondition
implements Condition {
    private final InternalApproverService approverService;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public ApprovalActionEnabledCondition(InternalApproverService approverService, JiraAuthenticationContext authenticationContext) {
        this.approverService = approverService;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return false;
        }
        Object issueObj = map.get("issue");
        if (issueObj == null) {
            return false;
        }
        Issue issue = (Issue)issueObj;
        return (Boolean)this.approverService.hasPendingApproval(issue, user).right().getOrElse((Object)false);
    }
}

