/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.lifecycle;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.util.runners.SealedRunner;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserProviderRegistry;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import com.atlassian.servicedesk.internal.spi.request.activitystream.ActivityProviderRegistry;
import com.atlassian.servicedesk.internal.spi.request.activitystream.providers.ActivityProvider;
import com.atlassian.servicedesk.plugins.approvals.internal.customfield.ApprovalsCFManager;
import com.atlassian.servicedesk.plugins.approvals.internal.events.listeners.ApprovalsEventListener;
import com.atlassian.servicedesk.plugins.approvals.internal.permission.ApproverRequestAccessUserStrategy;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ApprovalsPluginLauncher
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(ApprovalsPluginLauncher.class);
    private static final String PLUGIN_STARTED_EVENT = "plugin.started.event";
    private static final String LIFECYCLE_AWARE_ONSTART = "lifecycle.aware.onstart";
    private final ApprovalsEventListener approvalsEventListener;
    private final EventPublisher eventPublisher;
    private final ActivityProvider approvalsActivityProvider;
    private final ActivityProviderRegistry activityProviderRegistry;
    private final RequestAccessUserProviderRegistry requestAccessUserProviderRegistry;
    private final ApproverRequestAccessUserStrategy approverRequestAccessUserStrategy;
    private final ApprovalsCFManager approvalsCFManager;
    private LazyReference<SealedRunner> sealedStartCompleteRunner = new LazyReference<SealedRunner>(){

        protected SealedRunner create() throws Exception {
            return new SealedRunner((List)Lists.newArrayList((Object[])new String[]{ApprovalsPluginLauncher.PLUGIN_STARTED_EVENT, ApprovalsPluginLauncher.LIFECYCLE_AWARE_ONSTART}), () -> ApprovalsPluginLauncher.this.onStartCompleted());
        }
    };

    @Autowired
    public ApprovalsPluginLauncher(EventPublisher eventPublisher, ApprovalsEventListener approvalsEventListener, ActivityProvider approvalsActivityProvider, ActivityProviderRegistry activityProviderRegistry, RequestAccessUserProviderRegistry requestAccessUserProviderRegistry, ApproverRequestAccessUserStrategy approverRequestAccessUserStrategy, ApprovalsCFManager approvalsCFManager) {
        this.eventPublisher = eventPublisher;
        this.approvalsEventListener = approvalsEventListener;
        this.approvalsActivityProvider = approvalsActivityProvider;
        this.activityProviderRegistry = activityProviderRegistry;
        this.requestAccessUserProviderRegistry = requestAccessUserProviderRegistry;
        this.approverRequestAccessUserStrategy = approverRequestAccessUserStrategy;
        this.approvalsCFManager = approvalsCFManager;
    }

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
    }

    private void onStartCompleted() {
        log.info("Starting Approvals Plugin....");
        this.tenantlessSetup();
        this.tenantedSetup();
        log.info("Approvals Plugin is started...");
    }

    @EventListener
    public final void onPluginStarted(PluginEnabledEvent pluginEnabledEvent) {
        if ("com.atlassian.servicedesk.approvals-plugin".equals(pluginEnabledEvent.getPlugin().getKey())) {
            ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(PLUGIN_STARTED_EVENT);
        }
    }

    public void onStart() {
        ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(LIFECYCLE_AWARE_ONSTART);
    }

    private void tenantlessSetup() {
        this.requestAccessUserProviderRegistry.register((RequestAccessUserStrategy)this.approverRequestAccessUserStrategy);
        this.eventPublisher.register((Object)this.approvalsEventListener);
        this.activityProviderRegistry.registerApprovalsActivityProvider(this.approvalsActivityProvider);
    }

    private void tenantedSetup() {
        log.info("Initiate approvals customfield...");
        this.approvalsCFManager.getOrCreateApprovalsCF();
    }

    public void onStop() {
        log.info("Stopping Approvals Plugin...");
        this.tenantlessShutdown();
        log.info("Approvals Plugin is stopped");
    }

    private void tenantlessShutdown() {
        this.eventPublisher.unregister((Object)this);
        this.eventPublisher.unregister((Object)this.approvalsEventListener);
        if (this.isRequestAccessUserProviderRegistryAvailable()) {
            this.requestAccessUserProviderRegistry.unregister((RequestAccessUserStrategy)this.approverRequestAccessUserStrategy);
        } else {
            log.info("Skip unregister from RequestAccessUserProviderRegistry since it's already destroyed");
        }
        if (this.isActivityProviderRegistryAvailable()) {
            this.activityProviderRegistry.unregisterApprovalsActivityProvider();
        } else {
            log.info("Skip unregister from ActivityProviderRegistry since it's already destroyed");
        }
    }

    private boolean isRequestAccessUserProviderRegistryAvailable() {
        return ComponentAccessor.getOSGiComponentInstanceOfType(RequestAccessUserProviderRegistry.class) != null;
    }

    private boolean isActivityProviderRegistryAvailable() {
        return ComponentAccessor.getOSGiComponentInstanceOfType(ActivityProviderRegistry.class) != null;
    }
}

