/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.info;

import com.atlassian.servicedesk.plugins.approvals.internal.bootstrap.info.PluginInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class PluginInfoImpl
implements PluginInfo {
    private final String version;
    private final DateTime buildDate;
    private final String changeSet;

    public PluginInfoImpl() {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("/version/BuildProperties.properties");
        if (resourceAsStream == null) {
            throw new IllegalStateException("How come we cant find our BuildProperties.  We have a serious build issue");
        }
        Properties properties = new Properties();
        try {
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("How come we cant load our BuildProperties.  We have a serious build issue");
        }
        this.version = this.getRequired(properties, "sd.approvals.version");
        this.buildDate = new DateTime((Object)this.getRequired(properties, "sd.approvals.build.date"));
        this.changeSet = this.getOptional(properties, "sd.approvals.changeset", "DevVersion");
    }

    private String getRequired(Properties properties, String key) {
        return this.getBuildProp(properties, key, true);
    }

    private String getOptional(Properties properties, String key, String defaulValue) {
        String prop = this.getBuildProp(properties, key, false);
        return this.isNull(prop) ? defaulValue : prop;
    }

    private boolean isNull(String prop) {
        return StringUtils.isBlank((String)prop) || "null".equals(prop);
    }

    private String getBuildProp(Properties properties, String key, boolean required) {
        String prop = properties.getProperty(key);
        if (prop == null && required) {
            throw new IllegalStateException("How come we cant load a BuildProperty : " + key + ".  We have a serious build issue");
        }
        return prop;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public DateTime getBuildDate() {
        return this.buildDate;
    }

    @Override
    public String getChangeSet() {
        return this.changeSet;
    }
}

