/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approver;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfiguration;
import com.atlassian.servicedesk.internal.api.approver.InternalApproverService;
import com.atlassian.servicedesk.plugins.approvals.internal.approval.ApprovalManager;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverManager;
import com.atlassian.servicedesk.plugins.approvals.internal.decision.ApproverDecisionManager;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalPermissionChecker;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalApproverServiceImpl
implements InternalApproverService {
    private final ApproverManager approverManager;
    private final ApprovalPermissionChecker approvalPermissionChecker;
    private final ApprovalManager approvalManager;
    private final ApprovalError approvalError;
    private final ApproverDecisionManager approverDecisionManager;

    @Autowired
    public InternalApproverServiceImpl(@Nonnull ApproverManager approverManager, @Nonnull ApprovalPermissionChecker approvalPermissionChecker, @Nonnull ApprovalManager approvalManager, @Nonnull ApprovalError approvalError, @Nonnull ApproverDecisionManager approverDecisionManager) {
        this.approverManager = approverManager;
        this.approvalPermissionChecker = approvalPermissionChecker;
        this.approvalManager = approvalManager;
        this.approvalError = approvalError;
        this.approverDecisionManager = approverDecisionManager;
    }

    public Either<AnError, Collection<ApplicationUser>> getApprovers(ApplicationUser user, Approval approval) {
        boolean canView = this.approvalPermissionChecker.canViewApprover(user, approval);
        if (!canView) {
            return Either.left((Object)this.approvalError.VIEW_APPROVER_PERMISSION());
        }
        return Either.right(this.approverManager.getApprovers(approval));
    }

    public Either<AnError, Boolean> isApprover(ApplicationUser user, Approval approval, ApplicationUser approver) {
        boolean canView = this.approvalPermissionChecker.canViewApprover(user, approval);
        if (!canView) {
            return Either.left((Object)this.approvalError.VIEW_APPROVER_PERMISSION());
        }
        return Either.right((Object)this.approverManager.isApprover(approver, approval));
    }

    public Either<AnError, Collection<Approval>> getActiveApprovalsForUser(Issue issue, ApplicationUser user) {
        boolean canView = this.approvalPermissionChecker.canViewApproval(user);
        if (!canView) {
            return Either.left((Object)this.approvalError.VIEW_APPROVAL_PERMISSION());
        }
        Collection<Approval> activeApprovals = this.approvalManager.getActiveApprovals(issue);
        Collection userActiveApprovals = activeApprovals.stream().filter(approval -> this.approverManager.isApprover(user, (Approval)approval) && !this.approverDecisionManager.hasApproverMadeDecision((Approval)approval, user)).collect(Collectors.toList());
        return Either.right((Object)userActiveApprovals);
    }

    public Either<AnError, Option<Approval>> getFirstPendingApprovalForUser(Issue issue, ApplicationUser user) {
        boolean canView = this.approvalPermissionChecker.canViewApproval(user);
        if (!canView) {
            return Either.left((Object)this.approvalError.VIEW_APPROVAL_PERMISSION());
        }
        Collection<Approval> activeApprovals = this.approvalManager.getActiveApprovals(issue);
        Optional<Approval> activeApprovalForUser = activeApprovals.stream().filter(approval -> this.approverManager.isApprover(user, (Approval)approval) && !this.approverDecisionManager.hasApproverMadeDecision((Approval)approval, user)).findFirst();
        return Either.right((Object)Option.fromOptional(activeApprovalForUser));
    }

    public Collection<ApproverConfiguration> getApproverConfigurations(Approval approval) {
        return this.approverManager.getApproverConfigurations(approval);
    }

    public Either<AnError, Boolean> hasPendingApproval(Issue issue, ApplicationUser potentialApprover) {
        return Steps.begin(this.getActiveApprovalsForUser(issue, potentialApprover)).then(approvals -> Either.right((Object)(!approvals.isEmpty() ? 1 : 0))).yield((approvals, isPending) -> isPending);
    }
}

