/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approver;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfiguration;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationDataInput;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationType;
import com.atlassian.servicedesk.internal.api.approver.CustomFieldApproverConfiguration;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationData;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.ApproverConfigurationHandler;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.CustomFieldApproverConfigurationDataInput;
import com.atlassian.servicedesk.plugins.approvals.internal.approver.CustomFieldApproverConfigurationImpl;
import com.atlassian.servicedesk.plugins.approvals.internal.dao.ApproverDao;
import com.atlassian.servicedesk.plugins.approvals.internal.util.ApprovalError;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldApproverTypeConfigurationHandler
implements ApproverConfigurationHandler {
    private final FieldManager fieldManager;
    private final DatabaseAccessor databaseAccessor;
    private final ApproverDao approverDao;
    private final ApprovalError approvalError;

    @Autowired
    public CustomFieldApproverTypeConfigurationHandler(FieldManager fieldManager, DatabaseAccessor databaseAccessor, ApproverDao approverDao, ApprovalError approvalError) {
        this.fieldManager = fieldManager;
        this.databaseAccessor = databaseAccessor;
        this.approverDao = approverDao;
        this.approvalError = approvalError;
    }

    @Override
    public ApproverConfigurationType getType() {
        return ApproverConfigurationType.CUSTOM_FIELD;
    }

    @Override
    public boolean isApprover(ApplicationUser user, Issue issue, Collection<ApproverConfigurationData> datas) {
        return this.getUsers(issue, datas).contains(user);
    }

    @Override
    public Set<ApplicationUser> getUsers(Issue issue, Collection<ApproverConfigurationData> datas) {
        HashSet users = Sets.newHashSet();
        datas.forEach(data -> {
            Set<ApplicationUser> usersPerData = this.getUsers(issue, (ApproverConfigurationData)data);
            users.addAll(usersPerData);
        });
        return users;
    }

    @Override
    public boolean hasValidApproverConfigurationData(Collection<ApproverConfigurationData> datas) {
        return this.getApproverConfigurations(datas).size() > 0;
    }

    @Override
    public Collection<ApproverConfiguration> getApproverConfigurations(Collection<ApproverConfigurationData> datas) {
        return datas.stream().map(this::getCustomFieldConfiguration).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toList());
    }

    public Either<AnError, Collection<ApproverConfigurationDataInput>> toDataInput(String customFieldId) {
        CustomField customField = this.fieldManager.getCustomField(customFieldId);
        if (customField == null) {
            return Either.left((Object)this.approvalError.CUSTOM_FIELD_NOT_FOUND());
        }
        CustomFieldApproverConfigurationDataInput dataInput = new CustomFieldApproverConfigurationDataInput(customField, customFieldId);
        return Either.right((Object)Lists.newArrayList((Object[])new ApproverConfigurationDataInput[]{dataInput}));
    }

    public Collection<CustomFieldApproverConfiguration> getApproverConfigurationForPendingApprovals(Issue issue) {
        return (Collection)this.databaseAccessor.run(databaseConnection -> {
            Collection<ApproverConfigurationData> approverConfigurationDatas = this.approverDao.getActiveApproverConfigurations(issue, (DatabaseConnection)databaseConnection);
            return approverConfigurationDatas.stream().map(data -> this.getCustomFieldConfiguration((ApproverConfigurationData)data)).filter(cfOpt -> cfOpt.isDefined()).map(cfOpt -> (CustomFieldApproverConfiguration)cfOpt.get()).collect(Collectors.toList());
        });
    }

    private Set<ApplicationUser> getUsers(Issue issue, ApproverConfigurationData data) {
        Option<CustomFieldApproverConfiguration> customFieldConfiguration = this.getCustomFieldConfiguration(data);
        if (customFieldConfiguration.isDefined()) {
            CustomField customField = ((CustomFieldApproverConfiguration)customFieldConfiguration.get()).getCustomField();
            Object userObj = customField.getValue(issue);
            return this.convertCustomFieldValueToUsers(userObj);
        }
        return new HashSet<ApplicationUser>();
    }

    private Option<CustomFieldApproverConfiguration> getCustomFieldConfiguration(ApproverConfigurationData approverConfigurationData) {
        CustomField customField = this.fieldManager.getCustomField(approverConfigurationData.getValue());
        if (customField != null) {
            return Option.some((Object)new CustomFieldApproverConfigurationImpl(approverConfigurationData.getApprovalId(), customField));
        }
        return Option.none();
    }

    private Set<ApplicationUser> convertCustomFieldValueToUsers(Object userObj) {
        Object users = userObj instanceof Iterable ? ImmutableSet.copyOf((Iterable)((Iterable)userObj)) : (userObj instanceof ApplicationUser ? ImmutableSet.of((Object)((ApplicationUser)userObj)) : Collections.emptySet());
        return users;
    }
}

