/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approval;

import com.atlassian.jira.issue.Issue;
import com.atlassian.servicedesk.internal.api.approval.CreateApprovalParameters;
import com.atlassian.servicedesk.internal.api.approver.ApproverConfigurationDataInput;
import com.atlassian.servicedesk.internal.api.requirement.ApprovalCondition;
import com.atlassian.util.concurrent.Assertions;
import java.util.Collection;

public class CreateApprovalParametersImpl
implements CreateApprovalParameters {
    private final Issue issue;
    private final String name;
    private final String statusId;
    private final ApprovalCondition approvalCondition;
    private final Collection<ApproverConfigurationDataInput> configurationInputs;

    private CreateApprovalParametersImpl(Issue issue, String name, String statusId, ApprovalCondition approvalCondition, Collection<ApproverConfigurationDataInput> configurationInputs) {
        this.issue = issue;
        this.name = name;
        this.statusId = statusId;
        this.approvalCondition = approvalCondition;
        this.configurationInputs = configurationInputs;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String getName() {
        return this.name;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public Collection<ApproverConfigurationDataInput> getConfigurationInputs() {
        return this.configurationInputs;
    }

    public ApprovalCondition getApprovalCondition() {
        return this.approvalCondition;
    }

    public static CreateApprovalParameters.Builder builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl
    implements CreateApprovalParameters.Builder {
        private Issue issue;
        private String name;
        private String statusId;
        private ApprovalCondition approvalCondition;
        private Collection<ApproverConfigurationDataInput> configurationInputs;

        public CreateApprovalParameters.Builder issue(Issue issue) {
            Assertions.notNull((String)"Issue", (Object)issue);
            this.issue = issue;
            return this;
        }

        public CreateApprovalParameters.Builder name(String name) {
            Assertions.notNull((String)"Name", (Object)name);
            this.name = name;
            return this;
        }

        public CreateApprovalParameters.Builder statusId(String statusId) {
            Assertions.notNull((String)"statusId", (Object)statusId);
            this.statusId = statusId;
            return this;
        }

        public CreateApprovalParameters.Builder configurationInputs(Collection<ApproverConfigurationDataInput> configurationInputs) {
            Assertions.notNull((String)"configurationInputs", configurationInputs);
            this.configurationInputs = configurationInputs;
            return this;
        }

        public CreateApprovalParameters.Builder approveCondition(ApprovalCondition condition) {
            Assertions.notNull((String)"condition", (Object)condition);
            this.approvalCondition = condition;
            return this;
        }

        public CreateApprovalParameters build() {
            return new CreateApprovalParametersImpl(this.issue, this.name, this.statusId, this.approvalCondition, this.configurationInputs);
        }
    }
}

