/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.approvals.internal.approval;

import com.atlassian.fugue.Option;
import com.atlassian.servicedesk.api.approval.ApprovalQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import java.util.Objects;

public class ApprovalQueryImpl
implements ApprovalQuery {
    private final Option<Long> issue;
    private final LimitedPagedRequest pagedRequest;

    private ApprovalQueryImpl(Option<Long> issue, LimitedPagedRequest pagedRequest) {
        this.issue = issue;
        this.pagedRequest = pagedRequest;
    }

    public Option<Long> issue() {
        return this.issue;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    private static final class Builder
    implements ApprovalQuery.Builder {
        private Option<Long> issue = Option.none();
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)50);

        private Builder() {
        }

        public ApprovalQuery.Builder issue(Long issue) {
            this.issue = Option.option((Object)issue);
            return this;
        }

        public ApprovalQuery.Builder pagedRequest(PagedRequest pagedRequest) {
            Objects.requireNonNull(pagedRequest);
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)50);
            return this;
        }

        public ApprovalQuery build() {
            return new ApprovalQueryImpl(this.issue, this.pagedRequest);
        }
    }
}

