/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.rest;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarService;
import com.atlassian.jira.plugins.workinghours.api.calendar.HolidayService;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.CalendarAccessManager;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.Operation;
import com.atlassian.jira.plugins.workinghours.internal.rest.CalendarResource;
import com.atlassian.jira.plugins.workinghours.internal.rest.response.DialogResponse;
import com.atlassian.jira.plugins.workinghours.internal.rest.response.TimeZoneResponse;
import com.atlassian.jira.plugins.workinghours.internal.rest.util.CalendarSerialiser;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.pocketknife.api.rest.AbstractRestResource;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/internal/dialog")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class WorkingHoursDialogResource
extends AbstractRestResource {
    private final CalendarService calendarService;
    private final CalendarSerialiser calendarSerialiser;
    private final TimeZoneService timeZoneService;
    private final ApplicationProperties applicationProperties;
    private final CalendarAccessManager calendarAccessManager;
    private final HolidayService holidayService;

    public WorkingHoursDialogResource(JiraAuthenticationContext jiraAuthenticationContext, CalendarService calendarService, CalendarSerialiser calendarSerialiser, TimeZoneService timeZoneService, ApplicationProperties applicationProperties, CalendarAccessManager calendarAccessManager, HolidayService holidayService) {
        super(WorkingHoursDialogResource.class, jiraAuthenticationContext);
        this.calendarService = calendarService;
        this.calendarSerialiser = calendarSerialiser;
        this.timeZoneService = timeZoneService;
        this.applicationProperties = applicationProperties;
        this.calendarAccessManager = calendarAccessManager;
        this.holidayService = holidayService;
    }

    @GET
    @Consumes(value={"application/json"})
    @TenantAware(value=TenancyScope.SUPPRESS)
    public Response getDisplayInfo(@QueryParam(value="filter") String filter) {
        Either<ErrorCollection, Map<String, String>> either = CalendarResource.parseFilter(filter);
        Map filterMap = either.isLeft() ? new HashMap() : (Map)either.right().get();
        return this.response(() -> {
            TimeZoneResponse defaultTimezone = this.getDefaultTimeZone();
            TimeZoneResponse defaultJiraTimezone = new TimeZoneResponse(defaultTimezone.id, this.jiraAuthenticationContext.getI18nHelper().getText("workinghours.dialog.form.timezone.default", defaultTimezone.displayName));
            List<Calendar> result = this.calendarService.getAllByFilter(this.getUser(), filterMap);
            DialogResponse response = new DialogResponse();
            response.canCreate = this.calendarAccessManager.hasPermission(this.getUser(), filterMap, Operation.CREATE);
            response.calendars = this.calendarSerialiser.fromCalendars(this.getUser(), result);
            response.calendarNameLimit = this.calendarService.getCalendarNameLimit();
            response.holidayNameLimit = this.holidayService.getHolidayNameLimit();
            response.allTimezones = this.getAllTimeZoneResponses(defaultJiraTimezone);
            response.defaultTimezone = defaultJiraTimezone;
            response.dateFormat = this.getJIRADateFormat();
            return this.ok(response);
        });
    }

    private List<TimeZoneResponse> getAllTimeZoneResponses(TimeZoneResponse defaultJiraTimezone) {
        JiraServiceContextImpl context = new JiraServiceContextImpl((ApplicationUser)null);
        List timeZoneInfos = this.timeZoneService.getTimeZoneInfos((JiraServiceContext)context);
        ArrayList<TimeZoneResponse> toReturn = new ArrayList<TimeZoneResponse>();
        if (defaultJiraTimezone != null) {
            toReturn.add(defaultJiraTimezone);
        }
        for (TimeZoneInfo tzi : timeZoneInfos) {
            toReturn.add(new TimeZoneResponse(tzi.getTimeZoneId(), this.formatTimezoneDisplay(tzi)));
        }
        return toReturn;
    }

    private TimeZoneResponse getDefaultTimeZone() {
        JiraServiceContextImpl context = new JiraServiceContextImpl((ApplicationUser)null);
        TimeZoneInfo defaultTimezone = this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)context);
        return new TimeZoneResponse(defaultTimezone.getTimeZoneId(), this.formatTimezoneDisplay(defaultTimezone));
    }

    private String getJIRADateFormat() {
        return this.applicationProperties.getDefaultBackedString("jira.date.picker.javascript.format");
    }

    private String formatTimezoneDisplay(TimeZoneInfo tzi) {
        return tzi.getGMTOffset() + " " + tzi.getCity();
    }
}

