/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.rest;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculatorService;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarService;
import com.atlassian.jira.plugins.workinghours.internal.rest.response.IntervalRangesResponse;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.pocketknife.api.rest.AbstractRestResource;
import com.atlassian.pocketknife.step.StepsConverters;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.Interval;

@Path(value="/api/intervals")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class CalculatorResource
extends AbstractRestResource {
    private final CalendarService calendarService;
    private final WorkingHoursCalculatorService workingHoursCalculatorService;
    private final ApplicationProperties applicationProperties;

    public CalculatorResource(JiraAuthenticationContext jiraAuthenticationContext, CalendarService calendarService, WorkingHoursCalculatorService workingHoursCalculatorService, ApplicationProperties applicationProperties) {
        super(CalculatorResource.class, jiraAuthenticationContext);
        this.calendarService = calendarService;
        this.workingHoursCalculatorService = workingHoursCalculatorService;
        this.applicationProperties = applicationProperties;
    }

    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public Response getRanges(@PathParam(value="id") int id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="duration") Long duration) {
        return this.response(() -> {
            Either result = StepsConverters.newerEither(this.calendarService.get(this.getUser(), id));
            if (result.isLeft()) {
                return this.errorResponse("calendar.get.failed", (ErrorCollection)result.left().get());
            }
            if (start == null) {
                return this.badRequest("start must be specified");
            }
            if (end == null && duration == null) {
                return this.badRequest("either end or duration must be specified");
            }
            if (end != null && duration != null) {
                return this.badRequest("Only end OR duration can be specified, not both together");
            }
            WorkingHoursCalculator calculator = this.workingHoursCalculatorService.getCalculatorForCalendar((Calendar)result.right().get());
            List<Interval> ranges = null;
            ranges = end != null ? calculator.getActiveRanges(new Interval(start.longValue(), end.longValue())) : calculator.getActiveRanges(new DateTime((Object)start), duration);
            return this.ok(IntervalRangesResponse.from(ranges));
        });
    }
}

