/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar.dao;

import com.atlassian.jira.plugins.workinghours.api.calendar.Weekday;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTime;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTimeBuilder;
import com.atlassian.jira.plugins.workinghours.internal.ao.schema.current.WorkingHoursDbSchema;
import com.atlassian.pocketknife.api.ao.dao.RelatedAOMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class WorkingTimeAOMapper
implements RelatedAOMapper<WorkingHoursDbSchema.CalendarAO, WorkingHoursDbSchema.WorkingTimeAO, WorkingTime> {
    public static final String CALENDAR_ID_COL = "CALENDAR_ID";
    public static final String DAY_COL = "DAY";
    public static final String START_TIME_COL = "START_TIME";
    public static final String END_TIME_COL = "END_TIME";

    public Map<String, Object> toAO(WorkingHoursDbSchema.CalendarAO calendarAO, WorkingTime workingTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.toAO(workingTime));
        map.put(CALENDAR_ID_COL, calendarAO);
        return map;
    }

    public Map<String, Object> toAO(WorkingTime workingTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DAY_COL, workingTime.getWeekday().getName());
        map.put(START_TIME_COL, this.ensureNotNull(workingTime.getStart()));
        map.put(END_TIME_COL, this.ensureNotNull(workingTime.getEnd()));
        return map;
    }

    public WorkingTime toModel(WorkingHoursDbSchema.WorkingTimeAO workingTimeAO) {
        WorkingTimeBuilder builder = WorkingTimeBuilder.builder();
        builder.weekday(Weekday.byName(workingTimeAO.getDay()));
        builder.start(workingTimeAO.getStartTime());
        builder.end(workingTimeAO.getEndTime());
        return builder.build();
    }

    public List<WorkingTime> toModel(List<WorkingHoursDbSchema.WorkingTimeAO> workingTimeAOs) {
        ArrayList<WorkingTime> models = new ArrayList<WorkingTime>(workingTimeAOs.size());
        for (WorkingHoursDbSchema.WorkingTimeAO workingTimeAO : workingTimeAOs) {
            models.add(this.toModel(workingTimeAO));
        }
        return models;
    }

    public void update(WorkingTime workingTime, WorkingHoursDbSchema.WorkingTimeAO workingTimeAO) {
        workingTimeAO.setDay(workingTime.getWeekday().getName());
        workingTimeAO.setStartTime(this.ensureNotNull(workingTime.getStart()));
        workingTimeAO.setEndTime(this.ensureNotNull(workingTime.getEnd()));
    }

    private Long ensureNotNull(Long l) {
        return l != null ? l : 0L;
    }
}

