/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar.dao;

import com.atlassian.jira.plugins.workinghours.api.calendar.Holiday;
import com.atlassian.jira.plugins.workinghours.internal.ao.schema.current.WorkingHoursDbSchema;
import com.atlassian.jira.plugins.workinghours.internal.calendar.dao.HolidayAOMapper;
import com.atlassian.pocketknife.api.ao.dao.AOListMapper;
import com.atlassian.pocketknife.api.ao.dao.RelatedAOMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.java.ao.Entity;

public class HolidayAOListMapper
implements AOListMapper<WorkingHoursDbSchema.HolidayAO, Holiday> {
    private WorkingHoursDbSchema.CalendarAO parentAO;
    private RelatedAOMapper<WorkingHoursDbSchema.CalendarAO, WorkingHoursDbSchema.HolidayAO, Holiday> mapper;

    public HolidayAOListMapper(WorkingHoursDbSchema.CalendarAO parentAO, RelatedAOMapper<WorkingHoursDbSchema.CalendarAO, WorkingHoursDbSchema.HolidayAO, Holiday> mapper) {
        this.parentAO = parentAO;
        this.mapper = mapper;
    }

    public WorkingHoursDbSchema.HolidayAO[] getExisting() {
        return this.parentAO.getHolidays();
    }

    public WorkingHoursDbSchema.HolidayAO findExisting(WorkingHoursDbSchema.HolidayAO[] holidayAOs, Holiday holiday) {
        for (WorkingHoursDbSchema.HolidayAO ao : holidayAOs) {
            if (!ao.getDateString().equals(HolidayAOMapper.dateToString(holiday.getDate())) || !ao.getName().equals(holiday.getName())) continue;
            return ao;
        }
        return null;
    }

    public Class<WorkingHoursDbSchema.HolidayAO> getActiveObjectClass() {
        return WorkingHoursDbSchema.HolidayAO.class;
    }

    public List<Holiday> fromAO(WorkingHoursDbSchema.HolidayAO[] holidayAOs) {
        ArrayList transformed = Lists.newArrayList();
        for (WorkingHoursDbSchema.HolidayAO ao : holidayAOs) {
            transformed.add(this.mapper.toModel((Entity)ao));
        }
        return transformed;
    }

    public void addCreateValues(Holiday holiday, Map<String, Object> params) {
        params.putAll(this.mapper.toAO((Object)this.parentAO, (Object)holiday));
    }

    public void setValues(WorkingHoursDbSchema.HolidayAO holidayAO, Holiday holiday) {
        this.mapper.update((Object)holiday, (Entity)holidayAO);
    }

    public void postCreateUpdate(WorkingHoursDbSchema.HolidayAO holidayAO, Holiday holiday) {
    }

    public void preDelete(WorkingHoursDbSchema.HolidayAO t) {
    }
}

