/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar.dao;

import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarBuilder;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.internal.ao.schema.current.WorkingHoursDbSchema;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.ao.dao.AOMapper;
import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Component;

@Component
public class CalendarAOMapper
implements AOMapper<WorkingHoursDbSchema.CalendarAO, CalendarInfo> {
    Log log = Log.with(this.getClass());
    public static final String NAME_COL = "NAME";
    public static final String TIMEZONE_COL = "TIMEZONE";
    public static final String CONTEXT_COL = "CONTEXT";

    public Map<String, Object> toAO(CalendarInfo calendar) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(NAME_COL, calendar.getName());
        map.put(TIMEZONE_COL, this.toTimezoneId(calendar.getTimeZone()));
        map.put(CONTEXT_COL, this.getContextMapJson(calendar.getContext()));
        return map;
    }

    public CalendarInfo toModel(WorkingHoursDbSchema.CalendarAO calendarAO) {
        CalendarBuilder builder = CalendarBuilder.builder();
        builder.id(calendarAO.getID());
        builder.name(StringUtils.defaultIfEmpty((String)calendarAO.getName(), (String)"Unnamed"));
        builder.context(this.getContextMap(calendarAO.getContext()));
        builder.timezone(this.getTimezoneForId(calendarAO.getTimezone()));
        return builder.buildInfo();
    }

    private DateTimeZone getTimezoneForId(String timezoneId) {
        return DateTimeZone.forID((String)timezoneId);
    }

    private String toTimezoneId(DateTimeZone timeZone) {
        return timeZone.getID();
    }

    private Map<String, String> getContextMap(String s) {
        String contextString = StringUtils.defaultString((String)s);
        HashMap context = Maps.newHashMap();
        try {
            JSONObject jsonObject = new JSONObject(contextString);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = jsonObject.getString(key);
                context.put(key, value);
            }
        }
        catch (JSONException e) {
            this.log.warn("Invalid calendar context: '" + contextString + "'", new Object[0]);
        }
        return context;
    }

    private String getContextMapJson(Map<String, String> context) {
        if (context == null) {
            context = Maps.newHashMap();
        }
        JSONObject object = new JSONObject();
        for (Map.Entry entry : context.entrySet()) {
            try {
                object.put((String)entry.getKey(), entry.getValue());
            }
            catch (JSONException e) {
                this.log.warn("Unable to add value to json object: %s", new Object[]{e.getMessage()});
            }
        }
        return object.toString();
    }

    public void update(CalendarInfo calendar, WorkingHoursDbSchema.CalendarAO calendarAO) {
        calendarAO.setName(calendar.getName());
        calendarAO.setContext(this.getContextMapJson(calendar.getContext()));
        calendarAO.setTimezone(this.toTimezoneId(calendar.getTimeZone()));
    }
}

