/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calendar.access;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.CalendarAccessManager;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.Operation;
import com.atlassian.jira.plugins.workinghours.internal.calendar.access.CalendarAccessModuleDescriptor;
import com.atlassian.jira.plugins.workinghours.spi.calendar.access.CalendarAccess;
import com.atlassian.jira.plugins.workinghours.spi.calendar.access.Outcome;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class CalendarAccessManagerImpl
implements CalendarAccessManager {
    protected final Log log = Log.with(this.getClass());
    @Autowired
    private GlobalPermissionManager globalPermissionManager;
    @Autowired
    private PluginAccessor pluginAccessor;

    @Override
    public boolean matchesFilter(ApplicationUser user, CalendarInfo info, Map<String, String> filter) {
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        Outcome outcome = this.matchFilterDelegated(user, info, filter);
        return this.handleOutcomeForFiltering(user, outcome);
    }

    @Override
    public boolean hasPermission(ApplicationUser user, Map<String, String> context, Operation operation) {
        Outcome outcome = this.hasPermissionDelegated(user, context, operation);
        return this.handleOutcomeForPermissioning(user, outcome);
    }

    @Override
    public Either<ErrorCollection, Option<Object>> validate(ApplicationUser user, Calendar calendar, Operation operation) {
        return StepsConverters.olderEither(this.collectValidate(user, calendar, operation)).map(StepsConverters::olderOption);
    }

    @Override
    public List<String> getOperationMessages(ApplicationUser user, Calendar calendar, Operation operation) {
        return this.handleGetOperationMessages(user, calendar, operation);
    }

    private List<String> handleGetOperationMessages(ApplicationUser user, Calendar calendar, Operation operation) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CalendarAccessModuleDescriptor.class);
        ArrayList<String> operationMessage = new ArrayList<String>();
        for (CalendarAccessModuleDescriptor moduleDescriptor : moduleDescriptors) {
            try {
                List<String> response = ((CalendarAccess)moduleDescriptor.getModule()).getOperationMessages(user, calendar, operation);
                if (response == null) continue;
                operationMessage.addAll(response);
            }
            catch (Exception e) {
                this.log.warnDebug(e, "Plugin module %s threw exception %s while executing getOperationMessages", new Object[]{moduleDescriptor.getCompleteKey(), e.getMessage()});
            }
        }
        return operationMessage;
    }

    private Outcome matchFilterDelegated(ApplicationUser user, CalendarInfo info, Map<String, String> filter) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CalendarAccessModuleDescriptor.class);
        HashSet results = Sets.newHashSetWithExpectedSize((int)3);
        for (CalendarAccessModuleDescriptor moduleDescriptor : moduleDescriptors) {
            try {
                Outcome outcome = ((CalendarAccess)moduleDescriptor.getModule()).matchesFilter(user, info, filter);
                if (outcome == Outcome.ABSTAIN) continue;
                results.add(outcome);
            }
            catch (Exception e) {
                this.log.warnDebug(e, "Plugin module %s threw exception %s while executing matchesFilter", new Object[]{moduleDescriptor.getCompleteKey(), e.getMessage()});
            }
        }
        return this.noThenYes(results);
    }

    private Outcome hasPermissionDelegated(ApplicationUser user, Map<String, String> context, Operation operation) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CalendarAccessModuleDescriptor.class);
        HashSet results = Sets.newHashSetWithExpectedSize((int)3);
        for (CalendarAccessModuleDescriptor moduleDescriptor : moduleDescriptors) {
            try {
                Outcome outcome = ((CalendarAccess)moduleDescriptor.getModule()).hasPermission(user, context, operation);
                if (outcome == Outcome.ABSTAIN) continue;
                results.add(outcome);
            }
            catch (Exception e) {
                this.log.warnDebug(e, "Plugin module %s threw exception %s while executing hasPermission", new Object[]{moduleDescriptor.getCompleteKey(), e.getMessage()});
            }
        }
        return this.yesThenNo(results);
    }

    public io.atlassian.fugue.Either<ErrorCollection, io.atlassian.fugue.Option<Object>> collectValidate(ApplicationUser user, Calendar calendar, Operation operation) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CalendarAccessModuleDescriptor.class);
        SimpleErrorCollection result = new SimpleErrorCollection();
        for (CalendarAccessModuleDescriptor moduleDescriptor : moduleDescriptors) {
            try {
                io.atlassian.fugue.Either validationErrors = StepsConverters.newerEither(((CalendarAccess)moduleDescriptor.getModule()).validate(user, calendar, operation)).map(StepsConverters::newerOption);
                if (!validationErrors.isLeft()) continue;
                result.addErrorCollection((ErrorCollection)validationErrors.left().get());
            }
            catch (Exception e) {
                this.log.warnDebug(e, "Plugin module %s threw exception %s while executing validateDelete", new Object[]{moduleDescriptor.getCompleteKey(), e.getMessage()});
            }
        }
        if (result.hasAnyErrors()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection)result));
        }
        return StepsConverters.newerEither((Either)ServiceResult.ok()).map(StepsConverters::newerOption);
    }

    private boolean handleOutcomeForPermissioning(ApplicationUser user, Outcome outcome) {
        if (outcome == Outcome.ABSTAIN) {
            return this.fallbackPermissionCheck(user);
        }
        return outcome == Outcome.YES;
    }

    private boolean handleOutcomeForFiltering(ApplicationUser user, Outcome outcome) {
        if (outcome == Outcome.ABSTAIN) {
            return false;
        }
        return outcome == Outcome.YES;
    }

    private Outcome noThenYes(Set<Outcome> results) {
        if (results.isEmpty()) {
            return Outcome.ABSTAIN;
        }
        if (results.contains((Object)Outcome.NO)) {
            return Outcome.NO;
        }
        return Outcome.YES;
    }

    private Outcome yesThenNo(Set<Outcome> results) {
        if (results.isEmpty()) {
            return Outcome.ABSTAIN;
        }
        if (results.contains((Object)Outcome.YES)) {
            return Outcome.YES;
        }
        return Outcome.NO;
    }

    private boolean fallbackPermissionCheck(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

