/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calculator;

import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTimeRange;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DayTimeRanges {
    private List<DayTimeRange> ranges = Lists.newArrayList();

    public DayTimeRanges() {
    }

    public DayTimeRanges(List<DayTimeRange> ranges) {
        for (DayTimeRange range : ranges) {
            this.addRange(range);
        }
        this.sort();
    }

    private void sort() {
        Collections.sort(this.ranges);
    }

    public DayTimeRanges with(DayTimeRange range) {
        DayTimeRanges newRanges = new DayTimeRanges();
        newRanges.ranges = Lists.newArrayList(this.ranges);
        newRanges.addRange(range);
        newRanges.sort();
        return newRanges;
    }

    private void addRange(DayTimeRange rangeToAdd) {
        if (rangeToAdd.isEmpty()) {
            return;
        }
        Iterator<DayTimeRange> it = this.ranges.iterator();
        while (it.hasNext()) {
            DayTimeRange range = it.next();
            if (!range.canMergeWith(rangeToAdd)) continue;
            rangeToAdd = range.getUnion(rangeToAdd);
            it.remove();
        }
        this.ranges.add(rangeToAdd);
    }

    public List<DayTimeRange> getRanges() {
        return this.ranges;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }
}

