/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calculator;

import com.atlassian.jira.plugins.workinghours.internal.calculator.DayTime;

public class DayTimeRange
implements Comparable<DayTimeRange> {
    private DayTime start;
    private DayTime end;

    public DayTimeRange(DayTime aStart, DayTime aEnd) {
        this.start = aStart;
        this.end = aEnd;
        if (this.start.compareTo(this.end) > 0) {
            this.start = aEnd;
            this.end = aStart;
        }
    }

    public DayTimeRange(DayTimeRange aRange) {
        this(aRange.start, aRange.end);
    }

    public DayTime getStart() {
        return this.start;
    }

    public DayTime getEnd() {
        return this.end;
    }

    public boolean equals(Object aObj) {
        if (aObj instanceof DayTimeRange) {
            DayTimeRange range = (DayTimeRange)aObj;
            return range.start.equals(this.start) && range.end.equals(this.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() + this.end.hashCode();
    }

    public boolean isEmpty() {
        return this.start.equals(this.end);
    }

    public boolean canMergeWith(DayTimeRange other) {
        DayTimeRange higher;
        DayTimeRange lower;
        if (this.compareTo(other) < 0) {
            lower = this;
            higher = other;
        } else {
            lower = other;
            higher = this;
        }
        return lower.getEnd().compareTo(higher.getStart()) >= 0;
    }

    public DayTimeRange getUnion(DayTimeRange other) throws IllegalArgumentException {
        DayTimeRange higher;
        DayTimeRange lower;
        if (this.compareTo(other) < 0) {
            lower = this;
            higher = other;
        } else {
            lower = other;
            higher = this;
        }
        if (lower.getEnd().compareTo(higher.getStart()) < 0) {
            throw new IllegalArgumentException("The two ranges can't form a union as they don't overlap!");
        }
        DayTime unionStart = lower.getStart();
        DayTime unionEnd = lower.getEnd().compareTo(higher.getEnd()) < 0 ? higher.getEnd() : lower.getEnd();
        return new DayTimeRange(unionStart, unionEnd);
    }

    @Override
    public int compareTo(DayTimeRange aO) {
        int comp = this.start.compareTo(aO.start);
        if (comp != 0) {
            return comp;
        }
        return this.end.compareTo(aO.end);
    }

    public String toString() {
        return "DayTimeRange[" + this.start + "," + this.end + "]";
    }
}

