/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calculator;

public class DayTime
implements Comparable<DayTime> {
    public static final long NB_MS_IN_SECOND = 1000L;
    public static final long NB_SECOND_IN_MINUTE = 60L;
    public static final long NB_MS_IN_MINUTE = 60000L;
    public static final long NB_MINUTE_IN_HOUR = 60L;
    public static final long NB_MS_IN_HOUR = 3600000L;
    public static final DayTime END_OF_DAY = new DayTime(24, 0);
    public static final DayTime START_OF_DAY = new DayTime(0, 0);
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;

    public DayTime(int aHours, int aMinutes) {
        this.hours = aHours;
        this.minutes = aMinutes;
        this.seconds = 0;
        this.milliseconds = 0;
    }

    public DayTime(int aHours, int aMinutes, int aSeconds, int aMillis) {
        this.hours = aHours;
        this.minutes = aMinutes;
        this.seconds = aSeconds;
        this.milliseconds = aMillis;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public boolean isEndOfDay() {
        return this.hours == 24;
    }

    public boolean isStartOfDay() {
        return this.hours == 0 && this.minutes == 0 && this.seconds == 0 && this.milliseconds == 0;
    }

    @Override
    public int compareTo(DayTime aO) {
        int comp = this.hours - aO.hours;
        if (comp != 0) {
            return comp;
        }
        comp = this.minutes - aO.minutes;
        if (comp != 0) {
            return comp;
        }
        comp = this.seconds - aO.seconds;
        if (comp != 0) {
            return comp;
        }
        return this.milliseconds - aO.milliseconds;
    }

    public boolean equals(Object aObj) {
        if (aObj instanceof DayTime) {
            DayTime d = (DayTime)aObj;
            return d.hours == this.hours && d.minutes == this.minutes && d.seconds == this.seconds && d.milliseconds == this.milliseconds;
        }
        return false;
    }

    public int hashCode() {
        return this.hours + this.minutes + this.seconds + this.milliseconds;
    }

    public long toTimeInMillis() {
        return (long)this.hours * 3600000L + (long)this.minutes * 60000L + (long)this.seconds * 1000L + (long)this.milliseconds;
    }

    public static DayTime fromTimeInMillis(long timeInMillis) {
        int milliseconds = (int)(timeInMillis % 1000L);
        int seconds = (int)(timeInMillis / 1000L % 60L);
        int minutes = (int)(timeInMillis / 60000L % 60L);
        int hours = (int)(timeInMillis / 3600000L);
        return new DayTime(hours, minutes, seconds, milliseconds);
    }

    public String toString() {
        return "DayTime " + this.hours + ":" + this.minutes + ":" + this.seconds + "." + this.milliseconds;
    }
}

