/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.internal.calculator;

import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class AlwaysOnCalculator
implements WorkingHoursCalculator {
    private final DateTimeZone timeZone;

    public AlwaysOnCalculator(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Integer getId() {
        return null;
    }

    @Override
    public String getName() {
        return "Default (24/7)";
    }

    @Override
    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean exceedsMaximumRange(Interval interval) {
        return false;
    }

    @Override
    public List<Interval> getActiveRanges(Interval checkRange) {
        return Lists.newArrayList((Object[])new Interval[]{checkRange});
    }

    @Override
    public List<Interval> getIntervalsForDay(LocalDate day, DateTime lowerBoundary, DateTime upperBoundary) {
        return Lists.newArrayList((Object[])new Interval[]{new Interval((ReadableInstant)lowerBoundary, (ReadableInstant)upperBoundary)});
    }

    @Override
    public List<Interval> getActiveRanges(DateTime startDate, long duration) {
        ArrayList list = Lists.newArrayList();
        if (duration > 0L) {
            list.add(new Interval((ReadableInstant)startDate, (ReadableInstant)new DateTime(startDate.getMillis() + duration)));
        } else if (duration < 0L) {
            list.add(new Interval((ReadableInstant)new DateTime(startDate.getMillis() + duration), (ReadableInstant)startDate));
        }
        return list;
    }

    @Override
    public boolean isActive(DateTime dateTime) {
        return true;
    }
}

