/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workinghours.api.calendar;

import com.atlassian.jira.plugins.workinghours.api.calendar.Weekday;
import com.atlassian.jira.plugins.workinghours.api.calendar.WorkingTime;
import com.atlassian.jira.plugins.workinghours.internal.calendar.WorkingTimeImpl;

public class WorkingTimeBuilder {
    private Weekday weekday;
    private Long start;
    private Long end;

    public static WorkingTimeBuilder builder() {
        return new WorkingTimeBuilder();
    }

    public static WorkingTimeBuilder builder(WorkingTime workingTime) {
        return new WorkingTimeBuilder(workingTime);
    }

    private WorkingTimeBuilder() {
    }

    private WorkingTimeBuilder(WorkingTime workingTime) {
        if (workingTime != null) {
            this.weekday(workingTime.getWeekday());
            this.start(workingTime.getStart());
            this.end(workingTime.getEnd());
        }
    }

    public WorkingTimeBuilder weekday(Weekday weekday) {
        this.weekday = weekday;
        return this;
    }

    public WorkingTimeBuilder start(Long start) {
        this.start = start;
        return this;
    }

    public WorkingTimeBuilder end(Long end) {
        this.end = end;
        return this;
    }

    public WorkingTime build() {
        return new WorkingTimeImpl(0, this.weekday, this.start, this.end);
    }
}

