/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.uri.context;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.servicedesk.api.rest.util.uri.context.ContextUriInfo;
import com.atlassian.servicedesk.api.rest.util.uri.context.RequestScope;
import com.sun.jersey.api.core.ExtendedUriInfo;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class ContextUriInfoFactoryBean
extends AbstractFactoryBean {
    private final RequestScope scope;

    public ContextUriInfoFactoryBean(RequestScope scope) {
        this.scope = scope;
    }

    protected ContextUriInfo createInstance() throws Exception {
        ExtendedUriInfo uriInfo = this.scope.currentInvocation().getHttpContext().getUriInfo();
        return new ContextUriInfoImpl((UriInfo)uriInfo);
    }

    public Class<ContextUriInfo> getObjectType() {
        return ContextUriInfo.class;
    }

    static class ContextUriInfoImpl
    implements ContextUriInfo {
        private final UriInfo uriInfo;

        public ContextUriInfoImpl(UriInfo uriInfo) {
            this.uriInfo = (UriInfo)Assertions.notNull((String)"uriInfo", (Object)uriInfo);
        }

        public String getPath() {
            return this.uriInfo.getPath();
        }

        public String getPath(boolean decode) {
            return this.uriInfo.getPath(decode);
        }

        public List<PathSegment> getPathSegments() {
            return this.uriInfo.getPathSegments();
        }

        public List<PathSegment> getPathSegments(boolean decode) {
            return this.uriInfo.getPathSegments(decode);
        }

        public URI getRequestUri() {
            return this.uriInfo.getRequestUri();
        }

        public UriBuilder getRequestUriBuilder() {
            return this.uriInfo.getRequestUriBuilder();
        }

        public URI getAbsolutePath() {
            return this.uriInfo.getAbsolutePath();
        }

        public UriBuilder getAbsolutePathBuilder() {
            return this.uriInfo.getAbsolutePathBuilder();
        }

        public URI getBaseUri() {
            return this.uriInfo.getBaseUri();
        }

        public UriBuilder getBaseUriBuilder() {
            return this.uriInfo.getBaseUriBuilder();
        }

        public MultivaluedMap<String, String> getPathParameters() {
            return this.uriInfo.getPathParameters();
        }

        public MultivaluedMap<String, String> getPathParameters(boolean decode) {
            return this.uriInfo.getPathParameters(decode);
        }

        public MultivaluedMap<String, String> getQueryParameters() {
            return this.uriInfo.getQueryParameters();
        }

        public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
            return this.uriInfo.getQueryParameters(decode);
        }

        public List<String> getMatchedURIs() {
            return this.uriInfo.getMatchedURIs();
        }

        public List<String> getMatchedURIs(boolean decode) {
            return this.uriInfo.getMatchedURIs(decode);
        }

        public List<Object> getMatchedResources() {
            return this.uriInfo.getMatchedResources();
        }
    }
}

