/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.uri;

import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.servicedesk.api.rest.util.uri.context.ContextUriInfo;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UriKit {
    private final ContextUriInfo contextUriInfo;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    @Autowired
    public UriKit(ContextUriInfo contextUriInfo, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.contextUriInfo = (ContextUriInfo)Preconditions.checkNotNull((Object)contextUriInfo);
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Preconditions.checkNotNull((Object)velocityRequestContextFactory);
    }

    public UriBuilder getRequestUriBuilder() {
        UriBuilder baseUriBuilder;
        try {
            baseUriBuilder = this.contextUriInfo.getRequestUriBuilder();
        }
        catch (RuntimeException e) {
            baseUriBuilder = UriBuilder.fromUri((String)this.getExecutingRequestUrl());
        }
        return baseUriBuilder;
    }

    public UriBuilder getBaseUriBuilder() {
        UriBuilder baseUriBuilder;
        try {
            baseUriBuilder = this.contextUriInfo.getBaseUriBuilder();
        }
        catch (RuntimeException e) {
            baseUriBuilder = UriBuilder.fromUri((URI)this.getJIRABaseURI()).path("/rest/servicedeskapi/");
        }
        return baseUriBuilder;
    }

    public UriBuilder getAdminBaseUriBuilder() {
        return this.getBaseUriBuilder().path("admin/");
    }

    public URI getJIRABaseURI() {
        return UriKit.toURI(this.getJIRABasePath());
    }

    public String getContextPath() {
        HttpServletRequest request = (HttpServletRequest)Preconditions.checkNotNull((Object)ExecutingHttpRequest.get(), (Object)"How can you be calling this out a web request context?");
        return request.getContextPath();
    }

    public static URI toURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("You must supply a URI string that cant be made into a URI proper", e);
        }
    }

    public URI toCustomerURI(String uri) {
        return UriKit.toURI(uri.replace(this.getJIRABasePath(), this.getJIRABasePath() + "/servicedesk/customershim"));
    }

    public static String smooshPaths(String base, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        return base + path;
    }

    private String getJIRABasePath() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
    }

    private String getExecutingRequestUrl() {
        HttpServletRequest req = ExecutingHttpRequest.get();
        StringBuilder url = new StringBuilder();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String urlPath = req.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        url.append(urlPath);
        return url.toString();
    }
}

