/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util.analytics;

import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import com.atlassian.servicedesk.api.rest.util.analytics.PublicRestApiAnalyticEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.model.AbstractResourceMethod;
import io.atlassian.fugue.Option;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import javax.ws.rs.Path;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsInterceptor
implements ResourceInterceptor {
    private final AnalyticsService analyticsService;

    public AnalyticsInterceptor(AnalyticsService analyticsService) {
        this.analyticsService = analyticsService;
    }

    public void intercept(MethodInvocation invocation) throws IllegalAccessException, InvocationTargetException {
        try {
            invocation.invoke();
        }
        finally {
            this.analyticsService.fireAnalyticsEvent(this.buildAnalyticsEvent(invocation));
        }
    }

    private AnalyticsEvent buildAnalyticsEvent(MethodInvocation invocation) {
        Function<String, String> ensureLeftSlash = s -> s.startsWith("/") ? s : "/" + s;
        Function<String, String> ensureNoRightSlash = s -> s.endsWith("/") ? StringUtils.chop((String)s) : s;
        Class<?> resourceClass = invocation.getResource().getClass();
        AbstractResourceMethod jerseyMethod = invocation.getMethod();
        Method reflectMethod = jerseyMethod.getMethod();
        HttpContext httpContext = invocation.getHttpContext();
        HttpRequestContext request = httpContext.getRequest();
        Option resourcePath = Option.option((Object)resourceClass.getAnnotation(Path.class)).flatMap(p -> Option.option((Object)p.value())).map(ensureLeftSlash::apply).map(ensureNoRightSlash::apply);
        Option methodPath = Option.option((Object)reflectMethod.getAnnotation(Path.class)).flatMap(p -> Option.option((Object)p.value())).map(ensureLeftSlash::apply).map(ensureNoRightSlash::apply);
        String connectAddonKey = request.getHeaderValue("ap-client-key");
        return PublicRestApiAnalyticEvent.builder().setResourceName(resourceClass.getSimpleName()).setResourceMethodName(reflectMethod.getName()).setHttpMethodName(jerseyMethod.getHttpMethod()).setHttpResponseCode(httpContext.getResponse().getStatus()).setPath((String)resourcePath.getOrElse((Object)"") + (String)methodPath.getOrElse((Object)"")).setConnectAddon(connectAddonKey != null).setConnectAddonKey(connectAddonKey).setUserAgent(request.getHeaderValue("user-agent")).build();
    }
}

