/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.util;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.servicedesk.api.rest.util.I18nErrorMessage;
import com.google.common.base.Function;
import java.util.Arrays;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ErrorResponse {
    private String errorMessage;
    private I18nErrorMessage i18nErrorMessage;

    private ErrorResponse(String errorMessage, I18nErrorMessage i18nErrorMessage) {
        this.errorMessage = errorMessage;
        this.i18nErrorMessage = i18nErrorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public I18nErrorMessage getI18nErrorMessage() {
        return this.i18nErrorMessage;
    }

    public static ErrorResponse from(AnError anError) {
        I18nErrorMessage i18nErrorMessage = (I18nErrorMessage)anError.getMessage().getI18n().map(ErrorResponse.createI18nErrorMessage()).getOrNull();
        return new ErrorResponse(anError.getMessage().getMessage(), i18nErrorMessage);
    }

    private static Function<ErrorMessage.I18n, I18nErrorMessage> createI18nErrorMessage() {
        return i18n -> {
            String[] params = (String[])Arrays.stream(i18n.getParams()).map(Object::toString).toArray(String[]::new);
            return new I18nErrorMessage(i18n.getI18nKey(), params);
        };
    }
}

