/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler.util;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserNameConverter {
    private final UserManager userManager;
    private final ErrorResultHelper errorHelper;

    @Autowired
    public UserNameConverter(ErrorResultHelper errorHelper, UserManager userManager) {
        this.errorHelper = errorHelper;
        this.userManager = userManager;
    }

    public Either<AnError, Set<ApplicationUser>> getUsersByNames(Set<String> usernames) {
        List lookupResults = usernames.stream().map(this::getSingleUserByName).collect(Collectors.toList());
        ArrayList invalidUsers = Lists.newArrayList((Iterable)Eithers.filterLeft(lookupResults));
        if (invalidUsers.isEmpty()) {
            return Either.right((Object)Sets.newHashSet((Iterable)Eithers.filterRight(lookupResults)));
        }
        return Either.left((Object)this.invalidUsernamesError(invalidUsers));
    }

    private AnError invalidUsernamesError(List<String> invalidUsernames) {
        ArrayList sortedNames = Lists.newArrayList(invalidUsernames);
        Collections.sort(sortedNames);
        String usernameList = String.join((CharSequence)",", sortedNames);
        return this.errorHelper.badRequest400("sd.request.participants.validation.missing.usernames", new Object[]{usernameList}).build();
    }

    private Either<String, ApplicationUser> getSingleUserByName(String username) {
        return Option.option((Object)this.userManager.getUserByName(username)).toRight(Suppliers.ofInstance((Object)username));
    }
}

