/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler.util;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import io.atlassian.fugue.Either;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InputValidator {
    private final ErrorResultHelper errorResultHelper;
    private static final String BAD_REQUEST = "sd.rest.error.bad.request";

    @Autowired
    public InputValidator(ErrorResultHelper errorResultHelper) {
        this.errorResultHelper = errorResultHelper;
    }

    public Either<AnError, Long> validateLong(String string) {
        return this.validate(Long::valueOf, string);
    }

    public Either<AnError, Integer> validateInteger(String string) {
        return this.validate(Integer::valueOf, string);
    }

    private <T, R> Either<AnError, R> validate(Function<T, R> func, T t) {
        if (t == null) {
            return Either.left((Object)this.badRequest());
        }
        try {
            R r = func.apply(t);
            return Either.right(r);
        }
        catch (Exception e) {
            return Either.left((Object)this.badRequest());
        }
    }

    private AnError badRequest() {
        return this.errorResultHelper.badRequest400(BAD_REQUEST, new Object[0]).build();
    }
}

