/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantQuery;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantService;
import com.atlassian.servicedesk.api.request.participant.RequestParticipantUpdateParameters;
import com.atlassian.servicedesk.api.rest.dto.domain.request.participant.RequestParticipantUpdateDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestParticipantParameterAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.IssueIdOrKeyConverter;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.UserNameConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestParticipantParameterAssemblerImpl
implements RequestParticipantParameterAssembler {
    private final ServiceDeskCustomerRequestService customerRequestService;
    private final RequestParticipantService requestParticipantService;
    private final IssueIdOrKeyConverter issueIdOrKeyConverter;
    private final UserNameConverter userNameConverter;

    @Autowired
    public RequestParticipantParameterAssemblerImpl(ServiceDeskCustomerRequestService customerRequestService, RequestParticipantService requestParticipantService, IssueIdOrKeyConverter issueIdOrKeyConverter, UserNameConverter userNameConverter) {
        this.customerRequestService = customerRequestService;
        this.requestParticipantService = requestParticipantService;
        this.issueIdOrKeyConverter = issueIdOrKeyConverter;
        this.userNameConverter = userNameConverter;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RequestParticipantQuery> createQueryParameters(String issueIdOrKey, Integer start, Integer limit) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssueId(issueIdOrKey)).yield(issueId -> this.requestParticipantService.newQueryBuilder().customerRequest(issueId).pagedRequest(RestPagedRequest.fromQueryParams(start, limit)).build());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, RequestParticipantUpdateParameters> createUpdateParameters(ApplicationUser applicationUser, String issueIdOrKey, RequestParticipantUpdateDTO updateDTO) {
        return Steps.begin(this.getCustomerRequestByIdOrKey(applicationUser, issueIdOrKey)).then(request -> this.userNameConverter.getUsersByNames(updateDTO.getUsernames())).yield((request, participants) -> this.requestParticipantService.newUpdateBuilder().customerRequest(request).requestParticipants(participants).build());
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequest> getCustomerRequestByIdOrKey(ApplicationUser applicationUser, String issueIdOrKey) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssueId(issueIdOrKey)).then(issueId -> StepsConverters.newerEither((Either)this.customerRequestService.getCustomerRequests(applicationUser, this.customerRequestService.newQueryBuilder().issue(issueId).build()))).yield((issueId, requests) -> (CustomerRequest)requests.findFirst().get());
    }
}

