/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.organization.OrganizationService;
import com.atlassian.servicedesk.api.organization.UsersInOrganizationQuery;
import com.atlassian.servicedesk.api.organization.UsersOrganizationUpdateParameters;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.UsersOrganizationUpdateDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.OrganizationUserAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.UserNameConverter;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Unit;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrganizationUserAssemblerImpl
implements OrganizationUserAssembler {
    private final OrganizationService organizationService;
    private final UserNameConverter userNameConverter;

    @Autowired
    public OrganizationUserAssemblerImpl(OrganizationService organizationService, UserNameConverter userNameConverter) {
        this.organizationService = organizationService;
        this.userNameConverter = userNameConverter;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<ApplicationUser>> getUsersInOrganization(ApplicationUser applicationUser, int organizationId, PagedRequest pagedRequest) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.organizationService.getById(applicationUser, Integer.valueOf(organizationId)))).then(organization -> StepsConverters.newerEither((Either)this.organizationService.getUsersInOrganization(applicationUser, this.getQuery(pagedRequest, (CustomerOrganization)organization)))).yield((organization, users) -> users);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> removeUsersInOrganization(ApplicationUser user, int organizationId, UsersOrganizationUpdateDTO dto) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.organizationService.getById(user, Integer.valueOf(organizationId)))).then(organization -> this.userNameConverter.getUsersByNames(dto.getUsernames())).then((organization, users) -> StepsConverters.newerEither((Either)this.organizationService.removeUsersFromOrganization(user, this.getParameter((CustomerOrganization)organization, (Set<ApplicationUser>)users))).map(unit -> Unit.Unit())).yield((organization, users, unit) -> unit);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> addUserToOrganization(ApplicationUser user, int organizationId, UsersOrganizationUpdateDTO usersOrganizationUpdateDTO) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.organizationService.getById(user, Integer.valueOf(organizationId)))).then(organization -> this.userNameConverter.getUsersByNames(usersOrganizationUpdateDTO.getUsernames())).then((organization, users) -> StepsConverters.newerEither((Either)this.organizationService.addUsersToOrganization(user, this.getParameter((CustomerOrganization)organization, (Set<ApplicationUser>)users)))).yield((organization, users, result) -> Unit.Unit());
    }

    private UsersOrganizationUpdateParameters getParameter(CustomerOrganization organization, Set<ApplicationUser> users) {
        return this.organizationService.newUsersOrganizationUpdateParametersBuilder().users(users).organization(organization).build();
    }

    private UsersInOrganizationQuery getQuery(PagedRequest pagedRequest, CustomerOrganization organization) {
        return this.organizationService.newUsersInOrganizationQuery().pagedRequest(pagedRequest).customerOrganization(organization).build();
    }
}

