/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.request.transition.CustomerTransition;
import com.atlassian.servicedesk.api.request.transition.CustomerTransitionService;
import com.atlassian.servicedesk.api.rest.dto.domain.request.transition.CustomerTransitionExecutionDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.CustomerTransitionAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.InputValidator;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.IssueIdOrKeyConverter;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerTransitionAssemblerImpl
implements CustomerTransitionAssembler {
    private ServiceDeskCustomerRequestService serviceDeskCustomerRequestService;
    private CustomerTransitionService customerTransitionService;
    private IssueIdOrKeyConverter issueIdOrKeyConverter;
    private InputValidator inputValidator;

    @Autowired
    public CustomerTransitionAssemblerImpl(ServiceDeskCustomerRequestService serviceDeskCustomerRequestService, CustomerTransitionService customerTransitionService, IssueIdOrKeyConverter issueIdOrKeyConverter, InputValidator inputValidator) {
        this.serviceDeskCustomerRequestService = serviceDeskCustomerRequestService;
        this.customerTransitionService = customerTransitionService;
        this.issueIdOrKeyConverter = issueIdOrKeyConverter;
        this.inputValidator = inputValidator;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<CustomerTransition>> getCustomerTransitions(ApplicationUser user, String issueIdOrKey, PagedRequest pagedRequest) {
        return Steps.begin((io.atlassian.fugue.Either)this.issueIdOrKeyConverter.toIssueId(issueIdOrKey).map(issueId -> this.customerTransitionService.newQueryBuilder().issue(issueId).pagedRequest(pagedRequest).build())).then(customerTransitionQuery -> StepsConverters.newerEither((Either)this.customerTransitionService.getCustomerTransitions(user, customerTransitionQuery))).yield((customerTransitionQuery, availableTransitions) -> availableTransitions);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> executeCustomerTransition(ApplicationUser user, String issueIdOrKey, CustomerTransitionExecutionDTO customerTransitionExecutionDTO) {
        String commentBody = customerTransitionExecutionDTO.getAdditionalComment() == null ? "" : customerTransitionExecutionDTO.getAdditionalComment().getBody();
        return Steps.begin(this.getCustomerRequest(user, issueIdOrKey)).then(customerRequest -> this.inputValidator.validateInteger(customerTransitionExecutionDTO.getId()).map(transitionId -> this.customerTransitionService.newExecuteParameterBuilder().request(customerRequest).transitionId(transitionId).comment(commentBody).build())).then((customerRequest, executionParameters) -> StepsConverters.newerEither((Either)this.customerTransitionService.executeCustomerTransition(user, executionParameters))).yield((customerRequest, executionParameters, result) -> Unit.Unit());
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequest> getCustomerRequest(ApplicationUser user, String issueIdOrKey) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssueId(issueIdOrKey)).then(id -> StepsConverters.newerEither((Either)this.serviceDeskCustomerRequestService.getCustomerRequests(user, this.serviceDeskCustomerRequestService.newQueryBuilder().issue(id).build()).map(PagedResponse::findFirst))).yield((id, customerRequest) -> (CustomerRequest)customerRequest.get());
    }
}

