/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.field.FieldId;
import com.atlassian.servicedesk.api.field.FieldInputValue;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestChannelSource;
import com.atlassian.servicedesk.api.request.CustomerRequestCreateParameters;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.CustomerRequestStatusQuery;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.rest.dto.domain.request.MyCustomerRequestQuery;
import com.atlassian.servicedesk.api.rest.dto.domain.request.RequestCreateDTO;
import com.atlassian.servicedesk.api.rest.resource.assembler.CustomerRequestAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.InputValidator;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.IssueIdOrKeyConverter;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerRequestAssemblerImpl
implements CustomerRequestAssembler {
    private final ServiceDeskCustomerRequestService customerRequestService;
    private final ServiceDeskService serviceDeskService;
    private final RequestTypeService requestTypeService;
    private final IssueIdOrKeyConverter issueIdOrKeyConverter;
    private final InputValidator inputValidator;

    @Autowired
    public CustomerRequestAssemblerImpl(ServiceDeskCustomerRequestService customerRequestService, ServiceDeskService serviceDeskService, RequestTypeService requestTypeService, IssueIdOrKeyConverter issueIdOrKeyConverter, InputValidator inputValidator) {
        this.customerRequestService = customerRequestService;
        this.serviceDeskService = serviceDeskService;
        this.requestTypeService = requestTypeService;
        this.issueIdOrKeyConverter = issueIdOrKeyConverter;
        this.inputValidator = inputValidator;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerRequest> createCustomerRequest(ApplicationUser user, RequestCreateDTO requestCreateDTO) {
        io.atlassian.fugue.Either result = Steps.begin(this.inputValidator.validateLong(requestCreateDTO.getServiceDeskId())).then(sdId -> this.inputValidator.validateInteger(requestCreateDTO.getRequestTypeId())).then((sdId, rtId) -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, sdId.longValue()))).then((sdId, rtId, sd) -> this.getRequestType(user, sd.getId(), (int)rtId)).then((sdId, rtId, sd, rt) -> this.createCustomerRequest(user, (ServiceDesk)sd, (PagedResponse<RequestType>)rt, requestCreateDTO)).yield((sdId, rtId, sd, rt, cr) -> cr);
        return result.leftMap(error -> {
            int httpErrorCode = error.getHttpStatusCode() == 404 ? 400 : error.getHttpStatusCode();
            return new AnError(error.getMessage(), httpErrorCode, error.getErrorCode());
        });
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<CustomerRequest>> getMyCustomerRequests(ApplicationUser user, MyCustomerRequestQuery query, PagedRequest pagedRequest) {
        CustomerRequestQuery.REQUEST_OWNERSHIP requestOwnership = Optional.ofNullable(query.requestOwnership).map(CustomerRequestQuery.REQUEST_OWNERSHIP::valueOf).orElse(CustomerRequestQuery.REQUEST_OWNERSHIP.ALL_REQUESTS);
        CustomerRequestQuery.REQUEST_STATUS requestStatus = Optional.ofNullable(query.requestStatus).map(CustomerRequestQuery.REQUEST_STATUS::valueOf).orElse(CustomerRequestQuery.REQUEST_STATUS.ALL_REQUESTS);
        CustomerRequestQuery customerRequestQuery = this.customerRequestService.newQueryBuilder().requestOwnership(requestOwnership).requestStatus(requestStatus).searchTerm(query.searchTerm).serviceDesk(query.serviceDeskId).requestType(query.requestTypeId).pagedRequest(pagedRequest).build();
        return StepsConverters.newerEither((Either)this.customerRequestService.getCustomerRequests(user, customerRequestQuery));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, CustomerRequest> getCustomerRequest(ApplicationUser user, String issueIdOrKey) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssueId(issueIdOrKey)).then(issueId -> StepsConverters.newerEither((Either)this.customerRequestService.getCustomerRequests(user, this.customerRequestService.newQueryBuilder().issue(issueId).build()))).yield((issue, response) -> (CustomerRequest)response.findFirst().get());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<CustomerRequest.CustomerRequestStatus>> getCustomerRequestStatus(ApplicationUser user, CustomerRequest customerRequest) {
        CustomerRequestStatusQuery query = this.customerRequestService.newStatusQueryBuilder().issue(customerRequest.getIssue().getId().longValue()).build();
        return StepsConverters.newerEither((Either)this.customerRequestService.getCustomerRequestStatus(user, query));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<CustomerRequest.CustomerRequestStatus>> getCustomerRequestStatus(ApplicationUser user, String issueIdOrKey, PagedRequest pagedRequest) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssueId(issueIdOrKey)).then(issueId -> StepsConverters.newerEither((Either)this.customerRequestService.getCustomerRequestStatus(user, this.customerRequestService.newStatusQueryBuilder().issue(issueId.longValue()).pagedRequest(pagedRequest).build()))).yield((issueId, status) -> status);
    }

    private io.atlassian.fugue.Either<AnError, PagedResponse<RequestType>> getRequestType(ApplicationUser user, int serviceDeskId, int requestTypeId) {
        RequestTypeQuery requestTypeQuery = this.requestTypeService.newQueryBuilder().serviceDesk(Integer.valueOf(serviceDeskId)).requestType(Integer.valueOf(requestTypeId)).build();
        return StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(user, requestTypeQuery));
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequest> createCustomerRequest(ApplicationUser user, ServiceDesk serviceDesk, PagedResponse<RequestType> requestTypePagedResponse, RequestCreateDTO requestCreateDTO) {
        RequestType requestType = (RequestType)requestTypePagedResponse.findFirst().get();
        CustomerRequestCreateParameters.Builder builder = this.customerRequestService.newCreateBuilder().serviceDesk(serviceDesk).requestType(requestType);
        Map<String, Object> fieldValues = requestCreateDTO.getRequestFieldValues();
        for (String fieldId : fieldValues.keySet()) {
            builder.fieldValue(FieldId.withId((String)fieldId), this.toFieldValue(fieldValues.get(fieldId)));
        }
        builder.raiseOnBehalfOf(requestCreateDTO.getRaiseOnBehalfOf());
        if (requestCreateDTO.getRequestParticipants() != null) {
            Set reqParts = requestCreateDTO.getRequestParticipants().stream().collect(Collectors.toSet());
            builder.requestParticipants(reqParts);
        }
        builder.customerRequestChannelSource(CustomerRequestChannelSource.API);
        return StepsConverters.newerEither((Either)this.customerRequestService.createCustomerRequest(user, builder.build()));
    }

    private FieldInputValue toFieldValue(Object value) {
        return FieldInputValue.withValue((Object)value);
    }
}

