/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.assembler;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.approval.Approval;
import com.atlassian.servicedesk.api.approval.ApprovalDecisionType;
import com.atlassian.servicedesk.api.approval.ApprovalQuery;
import com.atlassian.servicedesk.api.approval.ApprovalService;
import com.atlassian.servicedesk.api.approval.Approver;
import com.atlassian.servicedesk.api.rest.resource.assembler.ApprovalAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.ApprovalResponseWrapper;
import com.atlassian.servicedesk.api.rest.resource.assembler.util.IssueIdOrKeyConverter;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Unit;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalAssemblerImpl
implements ApprovalAssembler {
    private final ApprovalService approvalService;
    private final IssueIdOrKeyConverter issueIdOrKeyConverter;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ApprovalAssemblerImpl(ApprovalService approvalService, IssueIdOrKeyConverter issueIdOrKeyConverter, ErrorResultHelper errorResultHelper) {
        this.approvalService = approvalService;
        this.issueIdOrKeyConverter = issueIdOrKeyConverter;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ApprovalResponseWrapper> getApprovalById(ApplicationUser applicationUser, String issueIdOrKey, int approvalId) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssue(issueIdOrKey)).then(issue -> StepsConverters.newerEither((Either)this.approvalService.getApprovalById(applicationUser, approvalId))).then((issue, approval) -> this.checkApprovalBelongToIssue((Approval)approval, (Issue)issue)).then((issue, approval, unit) -> this.toApprovalResponseWrapper(applicationUser, (Approval)approval)).yield((issue, approval, unit, result) -> result);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PagedResponse<ApprovalResponseWrapper>> getApprovals(ApplicationUser user, String issueIdOrKey, PagedRequest pagedRequest) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssueId(issueIdOrKey)).then(issueId -> io.atlassian.fugue.Either.right((Object)this.buildApprovalQuery((long)issueId, pagedRequest))).then((issueId, query) -> StepsConverters.newerEither((Either)this.approvalService.getApprovals(user, query))).then((issueId, query, approvals) -> this.toApprovalResponseWrapperPagedResponse(user, (PagedResponse<Approval>)approvals)).yield((issueId, query, approvals, result) -> result);
    }

    private io.atlassian.fugue.Either<AnError, ApprovalResponseWrapper> toApprovalResponseWrapper(ApplicationUser user, Approval approval) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.approvalService.getApprovers(user, approval))).then(approvers -> StepsConverters.newerEither((Either)this.approvalService.canAnswerApproval(user, approval))).yield((approvers, canAnswerApproval) -> new ApprovalResponseWrapper(approval, (List<Approver>)approvers, (boolean)canAnswerApproval));
    }

    private io.atlassian.fugue.Either<AnError, PagedResponse<ApprovalResponseWrapper>> toApprovalResponseWrapperPagedResponse(ApplicationUser user, PagedResponse<Approval> approvals) {
        List results = approvals.getResults();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Approval approval2 : results) {
            io.atlassian.fugue.Either<AnError, ApprovalResponseWrapper> wrapperEither = this.toApprovalResponseWrapper(user, approval2);
            if (wrapperEither.isLeft()) {
                return io.atlassian.fugue.Either.left((Object)wrapperEither.left().get());
            }
            builder.add(wrapperEither.right().get());
        }
        ImmutableList responseWrappers = builder.build();
        return io.atlassian.fugue.Either.right((Object)approvals.map(approval -> this.getMatchingResponseWrapper((List<ApprovalResponseWrapper>)responseWrappers, (Approval)approval)));
    }

    private ApprovalResponseWrapper getMatchingResponseWrapper(List<ApprovalResponseWrapper> responseWrappers, Approval approval) {
        return responseWrappers.stream().filter(wrapper -> Objects.equals(wrapper.getApproval().getId(), approval.getId())).findFirst().get();
    }

    private ApprovalQuery buildApprovalQuery(long issueId, PagedRequest pagedRequest) {
        return this.approvalService.newQueryBuilder().issue(Long.valueOf(issueId)).pagedRequest(pagedRequest).build();
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ApprovalResponseWrapper> answerApproval(ApplicationUser applicationUser, String issueIdOrKey, Integer approvalId, ApprovalDecisionType decision) {
        return Steps.begin(this.issueIdOrKeyConverter.toIssue(issueIdOrKey)).then(issue -> StepsConverters.newerEither((Either)this.approvalService.getApprovalById(applicationUser, approvalId.intValue()))).then((issue, approval) -> this.checkApprovalBelongToIssue((Approval)approval, (Issue)issue)).then((issue, approval, unit) -> StepsConverters.newerEither((Either)this.approvalService.answerApproval(applicationUser, approval, decision))).then((issue, approval, unit, updatedApproval) -> this.toApprovalResponseWrapper(applicationUser, (Approval)updatedApproval)).yield((issue, approval, unit, updatedApproval, result) -> result);
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, Unit> checkApprovalBelongToIssue(Approval approval, Issue issue) {
        if (Objects.equals(approval.getIssueId(), issue.getId())) {
            return io.atlassian.fugue.Either.right((Object)Unit.Unit());
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.approval.error.approval.not.exist", new Object[0]).build());
    }
}

