/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource.admin;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.admin.QueueSettingsDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.admin.QueueSettingsDTOFactory;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.queues.CustomQueueSettingsService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/queues")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class QueueSettingsResource
extends CommonResource {
    private final UserFactory userFactory;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final CustomQueueSettingsService customQueueSettingsService;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final CommonErrors commonErrors;
    private final QueueSettingsDTOFactory queueSettingsDTOFactory;
    private final AnalyticsService analyticsService;

    public QueueSettingsResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, UserFactory userFactory, InternalServiceDeskProjectManager internalServiceDeskProjectManager, CustomQueueSettingsService customQueueSettingsService, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, CommonErrors commonErrors, QueueSettingsDTOFactory queueSettingsDTOFactory, AnalyticsService analyticsService) {
        super(jiraAuthenticationContext, responseFactory);
        this.userFactory = userFactory;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.customQueueSettingsService = customQueueSettingsService;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.commonErrors = commonErrors;
        this.queueSettingsDTOFactory = queueSettingsDTOFactory;
        this.analyticsService = analyticsService;
    }

    @PUT
    @Path(value="/include-count")
    @ResponseType(value=Boolean.class, status=200)
    @ExperimentalApi
    public Response setCustomQueueIncludeCount(boolean includeCount) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(this.user()))).then(user -> this.customQueueSettingsService.setCustomQueueIncludeCountGlobally(user, includeCount)).yield((user, updatedState) -> updatedState);
        result.forEach(bool -> {
            if (bool.booleanValue()) {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountIncludeEnabledEvent());
            } else {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountIncludeDisabledEvent());
            }
        });
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.bimap(this.responseFactory::error, ResponseFactory::okNoCache));
    }

    @PUT
    @Path(value="/{projectKey}/include-count")
    @ResponseType(value=Boolean.class, status=200)
    @ExperimentalApi
    public Response setCustomQueueIncludeCount(@PathParam(value="projectKey") String projectKey, boolean includeCount) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(this.user()))).then(() -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.customQueueSettingsService.setCustomQueueIncludeCountProject(user, project, includeCount)).yield((user, project, updatedState) -> {
            if (updatedState.booleanValue()) {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountIncludeProjectEnabledEvent(project.getId()));
            } else {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountIncludeProjectDisabledEvent(project.getId()));
            }
            return updatedState;
        });
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.bimap(this.responseFactory::error, ResponseFactory::okNoCache));
    }

    @PUT
    @Path(value="/cache-count")
    @ResponseType(value=Boolean.class, status=200)
    @ExperimentalApi
    public Response setCustomQueueUseLazyCachedCountGlobally(boolean cacheCount) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(this.user()))).then(user -> this.customQueueSettingsService.setCustomQueueUseLazyCachedCountGlobally(user, cacheCount)).yield((user, updatedState) -> updatedState);
        result.forEach(bool -> {
            if (bool.booleanValue()) {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountCacheEnabledEvent());
            } else {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountCacheDisabledEvent());
            }
        });
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.bimap(this.responseFactory::error, ResponseFactory::okNoCache));
    }

    @PUT
    @Path(value="/{projectKey}/cache-count")
    @ResponseType(value=Boolean.class, status=200)
    @ExperimentalApi
    public Response setCustomQueueUseLazyCachedCountProject(@PathParam(value="projectKey") String projectKey, boolean cacheCount) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(this.user()))).then(() -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.customQueueSettingsService.setCustomQueueUseLazyCachedCountProject(user, project, cacheCount)).yield((user, project, updatedState) -> {
            if (updatedState.booleanValue()) {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountCacheProjectEnabledEvent(project.getId()));
            } else {
                this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountCacheProjectDisabledEvent(project.getId()));
            }
            return updatedState;
        });
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.bimap(this.responseFactory::error, ResponseFactory::okNoCache));
    }

    @GET
    @Path(value="/{projectKey}")
    @ResponseType(value=QueueSettingsDTO.class, status=200)
    @ExperimentalApi
    public Response getCurrentSettingForQueueCountOnProject(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(this.user()))).then(() -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then(this::isAllowedRetrieveCurrentSettings).yield((user, project, unit) -> project);
        result.forEach(project -> this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QueueCountProjectStatusRetrievedEvent(project.getId())));
        return this.responseFactory.createdResponse(result, this.queueSettingsDTOFactory);
    }

    private io.atlassian.fugue.Either<AnError, Unit> isAllowedRetrieveCurrentSettings(CheckedUser user, Project project) {
        if (this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)user) || this.serviceDeskLicenseAndPermissionService.canAdministerServiceDesk((SDUser)user, project) || this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)user, project)) {
            return io.atlassian.fugue.Either.right((Object)Unit.Unit());
        }
        return io.atlassian.fugue.Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
    }

    @EventName(value="servicedesk.queue.settings.resource.project.count.status.retrieved")
    private static class QueueCountProjectStatusRetrievedEvent
    extends AnalyticsEvent {
        private final long projectId;

        private QueueCountProjectStatusRetrievedEvent(long projectId) {
            this.projectId = projectId;
        }

        public long getProjectId() {
            return this.projectId;
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.project.cache.count.disabled")
    private static class QueueCountCacheProjectDisabledEvent
    extends AnalyticsEvent {
        private final long projectId;

        private QueueCountCacheProjectDisabledEvent(long projectId) {
            this.projectId = projectId;
        }

        public long getProjectId() {
            return this.projectId;
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.project.cache.count.enabled")
    private static class QueueCountCacheProjectEnabledEvent
    extends AnalyticsEvent {
        private final long projectId;

        private QueueCountCacheProjectEnabledEvent(long projectId) {
            this.projectId = projectId;
        }

        public long getProjectId() {
            return this.projectId;
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.global.cache.count.disabled")
    private static class QueueCountCacheDisabledEvent
    extends AnalyticsEvent {
        private QueueCountCacheDisabledEvent() {
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.global.cache.count.enabled")
    private static class QueueCountCacheEnabledEvent
    extends AnalyticsEvent {
        private QueueCountCacheEnabledEvent() {
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.project.include.count.disabled")
    private static class QueueCountIncludeProjectDisabledEvent
    extends AnalyticsEvent {
        private final long projectId;

        private QueueCountIncludeProjectDisabledEvent(long projectId) {
            this.projectId = projectId;
        }

        public long getProjectId() {
            return this.projectId;
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.project.include.count.enabled")
    private static class QueueCountIncludeProjectEnabledEvent
    extends AnalyticsEvent {
        private final long projectId;

        private QueueCountIncludeProjectEnabledEvent(long projectId) {
            this.projectId = projectId;
        }

        public long getProjectId() {
            return this.projectId;
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.global.include.count.disabled")
    private static class QueueCountIncludeDisabledEvent
    extends AnalyticsEvent {
        private QueueCountIncludeDisabledEvent() {
        }
    }

    @EventName(value="servicedesk.queue.settings.resource.global.include.count.enabled")
    private static class QueueCountIncludeEnabledEvent
    extends AnalyticsEvent {
        private QueueCountIncludeEnabledEvent() {
        }
    }
}

