/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.CreateTemporaryWebAttachmentResultDTO;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.TemporaryFileAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import io.atlassian.fugue.Either;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{serviceDeskId}/attachTemporaryFile")
public class TemporaryFileResource
extends CommonResource {
    private TemporaryFileAssembler temporaryFileAssembler;

    protected TemporaryFileResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, TemporaryFileAssembler temporaryFileAssembler) {
        super(jiraAuthenticationContext, responseFactory);
        this.temporaryFileAssembler = temporaryFileAssembler;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @ExperimentalApi
    @RequiresXsrfCheck
    public Response attachTemporaryFile(@PathParam(value="serviceDeskId") long serviceDeskId, @MultipartFormParam(value="file") Collection<FilePart> fileParts, @Context HttpServletRequest request) {
        Either<AnError, CreateTemporaryWebAttachmentResultDTO> result = this.temporaryFileAssembler.attachTemporaryFiles(this.user(), serviceDeskId, fileParts, request);
        return this.responseFactory.createdResponseNoLink(result, dto -> dto);
    }
}

