/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.ServiceDeskDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.ServiceDeskDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="servicedesk")
public class ServiceDeskResource
extends CommonResource {
    private final ServiceDeskService serviceDeskService;
    private final ServiceDeskDTOFactory serviceDeskDTOFactory;

    public ServiceDeskResource(JiraAuthenticationContext jiraAuthenticationContext, ServiceDeskService serviceDeskService, ServiceDeskDTOFactory serviceDeskDTOFactory, ResponseFactory responseFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.serviceDeskService = serviceDeskService;
        this.serviceDeskDTOFactory = serviceDeskDTOFactory;
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={ServiceDeskDTO.class}, status=200)
    @PublicRestApi
    public Response getServiceDesks(@QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        io.atlassian.fugue.Either result = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDesks(this.user(), RestPagedRequest.fromQueryParams(start, limit)));
        return this.responseFactory.pagedReponse(result, this.serviceDeskDTOFactory);
    }

    @GET
    @Path(value="{serviceDeskId}")
    @ResponseType(value=ServiceDeskDTO.class)
    @PublicRestApi
    public Response getServiceDeskById(@PathParam(value="serviceDeskId") long serviceDeskId) {
        io.atlassian.fugue.Either result = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(this.user(), serviceDeskId));
        return this.responseFactory.entityResponse(result, this.serviceDeskDTOFactory);
    }
}

