/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.rest.dto.domain.servicedesk.customer.ServiceDeskCustomerAddDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.ServiceDeskCustomerAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{serviceDeskId}/customer")
public class ServiceDeskCustomerResource
extends CommonResource {
    private final UserDTOFactory userDTOFactory;
    private final ServiceDeskCustomerAssembler serviceDeskCustomerAssembler;

    public ServiceDeskCustomerResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, UserDTOFactory userDTOFactory, ServiceDeskCustomerAssembler serviceDeskCustomerAssembler) {
        super(jiraAuthenticationContext, responseFactory);
        this.userDTOFactory = userDTOFactory;
        this.serviceDeskCustomerAssembler = serviceDeskCustomerAssembler;
    }

    @POST
    @ExperimentalApi
    @RequestType(value=ServiceDeskCustomerAddDTO.class)
    @ResponseType(value=PagedDTO.class, genericTypes={UserDTO.class}, status=200)
    public Response addCustomers(@PathParam(value="serviceDeskId") Long serviceDeskId, ServiceDeskCustomerAddDTO customerCreateDTO) {
        Either<AnError, PagedResponse<ApplicationUser>> result = this.serviceDeskCustomerAssembler.addCustomers(this.user(), serviceDeskId, customerCreateDTO);
        return this.responseFactory.pagedReponse(result, this.userDTOFactory);
    }
}

