/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.group.RequestTypeGroupDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.RequestTypeGroupAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{serviceDeskId}/requesttypegroup")
public class RequestTypeGroupResource
extends CommonResource {
    private final RequestTypeGroupAssembler requestTypeGroupAssembler;

    public RequestTypeGroupResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, RequestTypeGroupAssembler requestTypeGroupAssembler) {
        super(jiraAuthenticationContext, responseFactory);
        this.requestTypeGroupAssembler = requestTypeGroupAssembler;
    }

    @GET
    @ExperimentalApi
    @ResponseType(value=PagedDTO.class, genericTypes={RequestTypeGroupDTO.class}, status=200)
    @PublicRestApi
    public Response getRequestTypeGroups(@PathParam(value="serviceDeskId") Integer serviceDeskId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        Either<AnError, PagedResponse<RequestTypeGroup>> result = this.requestTypeGroupAssembler.getGroups(this.user(), serviceDeskId, this.pagedRequest(start, limit));
        return this.responseFactory.pagedReponse(result, this.dtoMapper());
    }

    private Function<RequestTypeGroup, RequestTypeGroupDTO> dtoMapper() {
        return group -> RequestTypeGroupDTO.builder().setId(String.valueOf(group.getId())).setName(group.getName()).build();
    }
}

