/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.rest.annotations.RunOutOfCustomerContext;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.QueueDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.QueueAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="servicedesk/{serviceDeskId}/queue")
@RunOutOfCustomerContext
public class QueueResource
extends CommonResource {
    private final QueueAssembler queueAssembler;

    public QueueResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, QueueAssembler queueAssembler) {
        super(jiraAuthenticationContext, responseFactory);
        this.queueAssembler = queueAssembler;
    }

    @GET
    @ExperimentalApi
    @ResponseType(value=PagedDTO.class, genericTypes={QueueDTO.class}, status=200)
    public Response getQueues(@PathParam(value="serviceDeskId") Long serviceDeskId, @QueryParam(value="includeCount") @DefaultValue(value="false") Boolean includeCount, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        return this.queueAssembler.getQueues(this.user(), serviceDeskId, includeCount, this.pagedRequest(start, limit));
    }

    @GET
    @Path(value="{queueId}/issue")
    @ExperimentalApi
    @ResponseType(value=PagedDTO.class, genericTypes={IssueBean.class}, status=200)
    public Response getIssuesInQueue(@PathParam(value="serviceDeskId") Long serviceDeskId, @PathParam(value="queueId") Long queueId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        return this.queueAssembler.getIssuesInQueue(this.user(), serviceDeskId, queueId, this.pagedRequest(start, limit));
    }
}

