/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.OrganizationCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.OrganizationDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.OrganizationDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.organization.UsersOrganizationUpdateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.user.UserDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.OrganizationAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.OrganizationUserAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="organization")
public class OrganizationResource
extends CommonResource {
    private final OrganizationAssembler organizationAssembler;
    private final OrganizationDTOFactory organizationDTOFactory;
    private final OrganizationUserAssembler organizationUserAssembler;
    private final UserDTOFactory userDTOFactory;

    public OrganizationResource(OrganizationAssembler organizationAssembler, JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, OrganizationDTOFactory organizationDTOFactory, OrganizationUserAssembler organizationUserAssembler, UserDTOFactory userDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.organizationAssembler = organizationAssembler;
        this.organizationDTOFactory = organizationDTOFactory;
        this.organizationUserAssembler = organizationUserAssembler;
        this.userDTOFactory = userDTOFactory;
    }

    @GET
    @ResponseType(value=OrganizationDTO.class)
    @Path(value="{organizationId}")
    @ExperimentalApi
    public Response getOrganization(@PathParam(value="organizationId") Integer organizationId) {
        Either<AnError, CustomerOrganization> result = this.organizationAssembler.getOrganization(this.user(), organizationId);
        return this.responseFactory.entityResponse(result, this.organizationDTOFactory);
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={OrganizationDTO.class}, status=200)
    @ExperimentalApi
    public Response getOrganizations(@QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        Either<AnError, PagedResponse<CustomerOrganization>> result = this.organizationAssembler.getOrganizations(this.user(), RestPagedRequest.fromQueryParams(start, limit));
        return this.responseFactory.pagedReponse(result, this.organizationDTOFactory);
    }

    @ResponseType(value=OrganizationDTO.class)
    @ExperimentalApi
    @POST
    @RequestType(value=OrganizationCreateDTO.class)
    public Response createOrganization(OrganizationCreateDTO organizationCreateDTO) {
        Either<AnError, CustomerOrganization> result = this.organizationAssembler.createOrganization(this.user(), organizationCreateDTO);
        return this.responseFactory.createdResponse(result, this.organizationDTOFactory);
    }

    @DELETE
    @Path(value="{organizationId}")
    @ExperimentalApi
    public Response deleteOrganization(@PathParam(value="organizationId") Integer organizationId) {
        Either<AnError, Unit> result = this.organizationAssembler.deleteOrganization(this.user(), organizationId);
        return (Response)result.fold(this.responseFactory::error, unit -> ResponseFactory.noContent());
    }

    @ResponseType(value=UserDTO.class)
    @ExperimentalApi
    @GET
    @Path(value="{organizationId}/user")
    public Response getUsersInOrganization(@PathParam(value="organizationId") int organizationId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        Either<AnError, PagedResponse<ApplicationUser>> result = this.organizationUserAssembler.getUsersInOrganization(this.user(), organizationId, this.pagedRequest(start, limit));
        return this.responseFactory.pagedReponse(result, this.userDTOFactory);
    }

    @ExperimentalApi
    @POST
    @Path(value="{organizationId}/user")
    @RequestType(value=UsersOrganizationUpdateDTO.class)
    public Response addUsersToOrganization(@PathParam(value="organizationId") int organizationId, UsersOrganizationUpdateDTO usersOrganizationUpdateDTO) {
        Either<AnError, Unit> result = this.organizationUserAssembler.addUserToOrganization(this.user(), organizationId, usersOrganizationUpdateDTO);
        return (Response)result.fold(this.responseFactory::error, unit -> ResponseFactory.noContent());
    }

    @ExperimentalApi
    @DELETE
    @Path(value="{organizationId}/user")
    public Response removeUsersFromOrganization(@PathParam(value="organizationId") int organizationId, UsersOrganizationUpdateDTO usersOrganizationUpdateDTO) {
        Either<AnError, Unit> result = this.organizationUserAssembler.removeUsersInOrganization(this.user(), organizationId, usersOrganizationUpdateDTO);
        return (Response)result.fold(this.responseFactory::error, unit -> ResponseFactory.noContent());
    }
}

