/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.request.transition.CustomerTransition;
import com.atlassian.servicedesk.api.rest.dto.domain.request.transition.CustomerTransitionDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.transition.CustomerTransitionDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.request.transition.CustomerTransitionExecutionDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.CustomerTransitionAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="request/{issueIdOrKey}/transition")
public class CustomerTransitionResource
extends CommonResource {
    private CustomerTransitionAssembler customerTransitionAssembler;
    private CustomerTransitionDTOFactory customerTransitionDTOFactory;

    @Autowired
    public CustomerTransitionResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, CustomerTransitionAssembler customerTransitionAssembler, CustomerTransitionDTOFactory customerTransitionDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.customerTransitionAssembler = customerTransitionAssembler;
        this.customerTransitionDTOFactory = customerTransitionDTOFactory;
    }

    @GET
    @ExperimentalApi
    @ResponseType(value=CustomerTransitionDTO.class, status=200)
    public Response getCustomerTransitions(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        Either<AnError, PagedResponse<CustomerTransition>> result = this.customerTransitionAssembler.getCustomerTransitions(this.user(), issueIdOrKey, RestPagedRequest.fromQueryParams(start, limit));
        return this.responseFactory.pagedReponse(result, this.customerTransitionDTOFactory);
    }

    @POST
    @ExperimentalApi
    @RequestType(value=CustomerTransitionExecutionDTO.class)
    public Response performCustomerTransition(@PathParam(value="issueIdOrKey") String issueIdOrKey, CustomerTransitionExecutionDTO customerTransitionExecutionDTO) {
        Either<AnError, Unit> result = this.customerTransitionAssembler.executeCustomerTransition(this.user(), issueIdOrKey, customerTransitionExecutionDTO);
        return (Response)result.fold(this.responseFactory::error, unit -> ResponseFactory.noContent());
    }
}

