/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.rest.annotations.PublicRestApi;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.request.CustomerRequestDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.request.MyCustomerRequestQuery;
import com.atlassian.servicedesk.api.rest.dto.domain.request.RequestCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.CustomerRequestAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.expansion.Expansions;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="request")
public class CustomerRequestResource
extends CommonResource {
    private final CustomerRequestAssembler customerRequestAssembler;
    private final CustomerRequestDTOFactory customerRequestDTOFactory;

    public CustomerRequestResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, CustomerRequestAssembler customerRequestAssembler, CustomerRequestDTOFactory customerRequestDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.customerRequestAssembler = customerRequestAssembler;
        this.customerRequestDTOFactory = customerRequestDTOFactory;
    }

    @POST
    @RequestType(value=RequestCreateDTO.class)
    @ResponseType(value=CustomerRequestDTO.class, status=201)
    @PublicRestApi
    public Response createCustomerRequest(RequestCreateDTO requestCreateDTO) {
        ApplicationUser loggedInUser = this.user();
        Either<AnError, CustomerRequest> result = this.customerRequestAssembler.createCustomerRequest(loggedInUser, requestCreateDTO);
        return this.responseFactory.createdResponse(result, this.customerRequestDTOFactory.dtoMapper(loggedInUser, Expansions.EMPTY));
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={CustomerRequestDTO.class}, status=200)
    @PublicRestApi
    public Response getMyCustomerRequests(@QueryParam(value="searchTerm") String searchTerm, @QueryParam(value="requestOwnership") String requestOwnership, @QueryParam(value="requestStatus") String requestStatus, @QueryParam(value="serviceDeskId") Integer serviceDeskId, @QueryParam(value="requestTypeId") Integer requestTypeId, @QueryParam(value="expand") List<String> expand, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        ApplicationUser loggedInUser = this.user();
        MyCustomerRequestQuery query = new MyCustomerRequestQuery(searchTerm, requestOwnership, requestStatus, serviceDeskId, requestTypeId);
        Either<AnError, PagedResponse<CustomerRequest>> result = this.customerRequestAssembler.getMyCustomerRequests(loggedInUser, query, RestPagedRequest.fromQueryParams(start, limit));
        return this.responseFactory.pagedReponse(result, this.customerRequestDTOFactory.dtoMapper(loggedInUser, this.expansions(expand)));
    }

    @GET
    @Path(value="{issueIdOrKey}")
    @ResponseType(value=CustomerRequestDTO.class, status=200)
    @PublicRestApi
    public Response getCustomerRequestByIdOrKey(@PathParam(value="issueIdOrKey") String issueIdOrKey, @QueryParam(value="expand") List<String> expand) {
        ApplicationUser loggedInUser = this.user();
        Either<AnError, CustomerRequest> result = this.customerRequestAssembler.getCustomerRequest(this.user(), issueIdOrKey);
        return this.responseFactory.entityResponse(result, this.customerRequestDTOFactory.dtoMapper(loggedInUser, this.expansions(expand)));
    }
}

