/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.rest.annotation.ResponseTypes;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.util.ErrorResponse;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.expansion.Expansions;
import com.atlassian.servicedesk.api.util.expansion.ExpansionsParser;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResponseTypes(value={@ResponseType(value=ErrorResponse.class, statusType=ResponseType.StatusType.CLIENT_ERROR)})
public abstract class CommonResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    protected final ResponseFactory responseFactory;

    protected CommonResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.responseFactory = responseFactory;
    }

    protected ApplicationUser user() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    protected Expansions expansions(List<String> expands) {
        return ExpansionsParser.parseAsExpansions(expands);
    }

    protected PagedRequest pagedRequest(Integer start, Integer limit) {
        return RestPagedRequest.fromQueryParams(start, limit);
    }
}

