/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentCreateResultDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.attachment.AttachmentCreateResultDTOFactory;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.AttachmentAssembler;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import io.atlassian.fugue.Either;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="request/{issueIdOrKey}/attachment")
public class AttachmentResource
extends CommonResource {
    private final AttachmentAssembler attachmentAssembler;
    private final AttachmentCreateResultDTOFactory attachmentCreateResultDTOFactory;

    public AttachmentResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, AttachmentAssembler attachmentAssembler, AttachmentCreateResultDTOFactory attachmentCreateResultDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.attachmentAssembler = attachmentAssembler;
        this.attachmentCreateResultDTOFactory = attachmentCreateResultDTOFactory;
    }

    @POST
    @ExperimentalApi
    @RequestType(value=AttachmentCreateDTO.class)
    @ResponseType(value=AttachmentCreateResultDTO.class, status=201)
    public Response createAttachment(@PathParam(value="issueIdOrKey") String issueIdOrKey, AttachmentCreateDTO attachmentCreateDTO) {
        ApplicationUser user = this.user();
        Either<AnError, ServiceDeskComment> result = this.attachmentAssembler.attach(user, issueIdOrKey, attachmentCreateDTO);
        return this.responseFactory.createdResponseNoLink(result, this.attachmentCreateResultDTOFactory);
    }
}

