/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.resource;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApprovalDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApprovalDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.approval.ApprovalDecisionRequestDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.RestPagedRequest;
import com.atlassian.servicedesk.api.rest.resource.CommonResource;
import com.atlassian.servicedesk.api.rest.resource.assembler.ApprovalAssembler;
import com.atlassian.servicedesk.api.rest.resource.assembler.ApprovalResponseWrapper;
import com.atlassian.servicedesk.api.rest.util.ResponseFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import io.atlassian.fugue.Either;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="request/{issueIdOrKey}/approval")
public class ApprovalResource
extends CommonResource {
    private final ApprovalAssembler approvalAssembler;
    private final ApprovalDTOFactory approvalDTOFactory;

    public ApprovalResource(JiraAuthenticationContext jiraAuthenticationContext, ResponseFactory responseFactory, ApprovalAssembler approvalAssembler, ApprovalDTOFactory approvalDTOFactory) {
        super(jiraAuthenticationContext, responseFactory);
        this.approvalAssembler = approvalAssembler;
        this.approvalDTOFactory = approvalDTOFactory;
    }

    @GET
    @ResponseType(value=ApprovalDTO.class, status=200)
    @Path(value="{approvalId}")
    @ExperimentalApi
    public Response getApprovalById(@PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="approvalId") Integer approvalId) {
        ApplicationUser currentUser = this.user();
        Either<AnError, ApprovalResponseWrapper> approval = this.approvalAssembler.getApprovalById(currentUser, issueIdOrKey, approvalId);
        return this.responseFactory.entityResponse(approval, this.approvalDTOFactory.withUser(currentUser));
    }

    @POST
    @RequestType(value=ApprovalDecisionRequestDTO.class)
    @ResponseType(value=ApprovalDTO.class, status=200)
    @Path(value="{approvalId}")
    @ExperimentalApi
    public Response answerApproval(ApprovalDecisionRequestDTO decision, @PathParam(value="issueIdOrKey") String issueIdOrKey, @PathParam(value="approvalId") Integer approvalId) {
        ApplicationUser currentUser = this.user();
        Either<AnError, ApprovalResponseWrapper> approval = this.approvalAssembler.answerApproval(currentUser, issueIdOrKey, approvalId, decision.getDecision().decisionType());
        return this.responseFactory.entityResponse(approval, this.approvalDTOFactory.withUser(currentUser));
    }

    @GET
    @ResponseType(value=PagedDTO.class, genericTypes={ApprovalDTO.class}, status=200)
    @ExperimentalApi
    public Response getApprovals(@QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @PathParam(value="issueIdOrKey") String issueIdOrKey) {
        ApplicationUser currentUser = this.user();
        Either<AnError, PagedResponse<ApprovalResponseWrapper>> approvals = this.approvalAssembler.getApprovals(currentUser, issueIdOrKey, RestPagedRequest.fromQueryParams(start, limit));
        return this.responseFactory.pagedReponse(approvals, this.approvalDTOFactory.withUser(currentUser));
    }
}

