/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.examples;

import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeCreateDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.RequestTypeDTOFactory;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.icon.RequestTypeIconDTO;
import com.atlassian.servicedesk.api.rest.dto.domain.requesttype.icon.RequestTypeIconLinkDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.examples.ExampleHelper;
import com.atlassian.servicedesk.api.rest.util.uri.UriKit;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestTypeExamples {
    private static String serviceDeskId = "10001";
    public static final RequestTypeCreateDTO EXAMPLE_REQUEST_TYPE_CREATE_DTO = RequestTypeCreateDTO.builder().setIssueTypeId("10000").setName("Get IT Help").setDescription("Get IT Help").setHelpText("Please tell us clearly the problem you have within 100 words.").build();
    public static final RequestTypeDTO EXAMPLE = RequestTypeDTO.builder().setId("11001").setName("Get IT Help").setDescription("Get IT Help").setHelpText("Please tell us clearly the problem you have within 100 words.").set_links(ExampleHelper.jsdRestApiExampleUri("servicedesk/{serviceDeskId}/requesttype/{requestTypeId}").buildSelfLink(serviceDeskId, 11001)).setServiceDeskId(serviceDeskId).setIcon(RequestTypeExamples.buildIconDTO("12345")).setGroupIds((List<String>)ImmutableList.of((Object)"12")).build();
    public static final PagedDTO EXAMPLE_PAGE = ExampleHelper.standardPagedExample(3, "servicedesk/{serviceDeskId}/requesttype", serviceDeskId).addValue(EXAMPLE).addValue(RequestTypeDTO.builder().setId("11002").setName("Request a new account").setDescription("Request a new account").set_links(ExampleHelper.jsdRestApiExampleUri("servicedesk/{serviceDeskId}/requesttype/{requestTypeId}").buildSelfLink(serviceDeskId, 11002)).setServiceDeskId(serviceDeskId).setIcon(RequestTypeExamples.buildIconDTO("12346")).setGroupIds((List<String>)ImmutableList.of((Object)"13", (Object)"14")).build()).addValue(RequestTypeDTO.builder().setId("11003").setName("Hardware request").setDescription("Request a hardware support").set_links(ExampleHelper.jsdRestApiExampleUri("servicedesk/{serviceDeskId}/requesttype/{requestTypeId}").buildSelfLink(serviceDeskId, 11003)).setServiceDeskId(serviceDeskId).setIcon(RequestTypeExamples.buildIconDTO("12347")).setGroupIds((List<String>)ImmutableList.of((Object)"13")).build()).build();

    public static RequestTypeIconDTO buildIconDTO(String iconId) {
        String urlTemplate = "http://host:port/context/secure/viewavatar?avatarType=SD_REQTYPE&size=%s&avatarId=%s";
        Map<String, URI> iconUrls = RequestTypeDTOFactory.getIconSizes().stream().collect(Collectors.toMap(size -> size.getPixels() + "x" + size.getPixels(), size -> UriKit.toURI(String.format(urlTemplate, size.getParam(), iconId))));
        return RequestTypeIconDTO.builder().setId(iconId).set_links(RequestTypeIconLinkDTO.builder().setIconUrls(iconUrls).build()).build();
    }
}

