/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.api.rest.examples;

import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.servicedesk.api.rest.dto.domain.queue.QueueDTO;
import com.atlassian.servicedesk.api.rest.dto.paging.PagedDTO;
import com.atlassian.servicedesk.api.rest.examples.ExampleHelper;
import com.atlassian.servicedesk.api.rest.examples.IssueBeanExampleHelper;
import com.atlassian.servicedesk.api.rest.examples.UserExamples;
import com.google.common.collect.Lists;

public class QueueExamples {
    public static IssueBean SAMPLE_ISSUE_IN_QUEUE = null;
    public static PagedDTO SAMPLE_PAGE_OF_ISSUE_IN_QUEUE = null;
    public static QueueDTO SAMPLE_QUEUE_UNASSIGNED_ISSUE = QueueDTO.builder().setId("10").setName("Unassigned issues").setJql("project = SD AND assignee is EMPTY AND resolution = Unresolved ORDER BY \"Time to resolution\" ASC").setFields(Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "created", "reporter", "duedate"})).setIssueCount(10L).set_links(ExampleHelper.jsdRestApiExampleUri("servicedesk/{serviceDeskId}/queue/{queueId}").buildSelfLink(1, 10)).build();
    public static QueueDTO SAMPLE_QUEUE_ASSIGNED_TO_ME = QueueDTO.builder().setId("20").setName("Assigned to me").setJql("project = SD AND assignee = currentUser() AND resolution = Unresolved ORDER BY \"Time to resolution\" ASC").setFields(Lists.newArrayList((Object[])new String[]{"issuetype", "issuekey", "summary", "created", "reporter", "duedate"})).setIssueCount(10L).set_links(ExampleHelper.jsdRestApiExampleUri("servicedesk/{serviceDeskId}/queue/{queueId}").buildSelfLink(1, 20)).build();
    public static PagedDTO SAMPLE_PAGE_OF_QUEUE = ExampleHelper.standardPagedExample(2, "servicedesk/{serviceDeskId}/queue", 1).addValue(SAMPLE_QUEUE_UNASSIGNED_ISSUE).addValue(SAMPLE_QUEUE_ASSIGNED_TO_ME).build();

    static {
        SAMPLE_ISSUE_IN_QUEUE = new IssueBean(Long.valueOf(10001L), "SD-1", ExampleHelper.jsdRestApiExampleUri("rest/api/2/issue/{requestId}").buildURI(10001L));
        IssueBeanExampleHelper.addField(SAMPLE_ISSUE_IN_QUEUE, "summary", "My keyboard is broken");
        IssueBeanExampleHelper.addField(SAMPLE_ISSUE_IN_QUEUE, "reporter", UserExamples.FRED);
        IssueBeanExampleHelper.addField(SAMPLE_ISSUE_IN_QUEUE, "duedate", "2015-11-11T14:17:13.000+0700");
        IssueBeanExampleHelper.addField(SAMPLE_ISSUE_IN_QUEUE, "created", "2015-11-09T14:17:13.000+0700");
        IssueBeanExampleHelper.addField(SAMPLE_ISSUE_IN_QUEUE, "issuetype", IssueTypeJsonBean.shortBean((String)ExampleHelper.jiraRestApiExampleUri("issuetype/{issueTypeId}", 13), (String)"13", (String)"IT Help", (String)"For general IT problems and questions. Created by JIRA Service Desk.", (boolean)false, (Long)10002L, (String)"http://host:port/context/servicedesk/issue-type-icons?icon=it-help"));
        SAMPLE_PAGE_OF_ISSUE_IN_QUEUE = ExampleHelper.standardPagedExample(1, "servicedesk/1/queue/10/issue", new Object[0]).addValue(SAMPLE_ISSUE_IN_QUEUE).build();
    }
}

